<?php

class ActivityController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
    }

    public function indexAction()
    {
        $cur_page=1;
        if($this->_getParam("page")!=null)
            $cur_page=(int)$this->_getParam("page");
        
        $obj_activity = new Application_Model_ActivityLogic(-1);
        
        
        $adapter = new Zend_Paginator_Adapter_DbSelect($obj_activity->getActiveActivities(true));
        
        $paginator = new  Zend_Paginator($adapter);
        
        
        $paginator->setItemCountPerPage(20);
        $paginator->setCurrentPageNumber($cur_page);
        
        
        $this->view->paginator = $paginator;
        
        Zend_Paginator::setDefaultScrollingStyle("Sliding");
        Zend_View_Helper_PaginationControl::setDefaultViewPartial(
        "pagination.phtml"
        );
        
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', 'latest, events, modern, era, open, convent, school, institute, janakpuri, occasions, celebrations, alert, admission, calendar'); 
        $layout->assign('meta_desc', 'You can check the latest news, notice and announcement about R. K. Property Bindki Fatehpur.');
        $layout->assign('page_title', 'Activities');
    }
    
    public function activityAction()
    {
        $url = urldecode($this->_getParam('url'));
        
        $obj_activity = new Application_Model_ActivityLogic(-1);
        $obj_activity->getActivityByUrl($url);
        $this->view->activity = $obj_activity;
        
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', $obj_activity->get_activity_meta_key()); 
        $layout->assign('meta_desc', $obj_activity->get_activity_meta_desc());
        $layout->assign('page_title', $obj_activity->get_activity_title());
    }
    
    
}