<?php

class AdmissionController extends Zend_Controller_Action {

    public function init() {
        /* Initialize action controller here */
    }

    public function indexAction() {
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', 'latest, events, modern, era, open, convent, school, institute, janakpuri, occasions, celebrations, alert, admission, calendar');
        $layout->assign('meta_desc', 'Modern Era Convent is an English medium co-educational Senior Secondary School, recognized by the Directorate of Education, Delhi upto senior secondary and affiliated to the Central Board of Secondary Education.');
        $layout->assign('page_title', 'Admission');

        if ($this->getRequest()->isPost()) {
            $data = $this->getRequest()->getPost();
            $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
            $recaptcha_secret = '6LdXpeoUAAAAADkfBRTutYupN6AnBT9ifzO3SZ_e';
            $recaptcha_response = $data['recaptcha_response'];

            // Make and decode POST request:
            $recaptcha = file_get_contents($recaptcha_url . '?secret=' . $recaptcha_secret . '&response=' . $recaptcha_response);
            $recaptcha = json_decode($recaptcha);

            $sess = new Zend_Session_Namespace('msg');
            // Take action based on the score returned:
            if ($recaptcha->score >= 0.5) {
                
                $subject = 'New admission inquiry submitted through website at '.date('d-M-Y h:i A');
                $body = '<p>Hello Sir,</p><br /><p>We have received a new admission inquiry request. Please find the enclosed information.</p>'
                        . '<table><tr><td><b>Student Name: </b></td><td>'.$data['name'].'</td></tr>'
                        . '<tr><td><b>Gender: </b></td><td>'.$data['gender'].'</td></tr>'
                        . '<tr><td><b>Date of Birth: </b></td><td>'.$data['dob'].'</td></tr>'
                        . '<tr><td><b>Admission into Class: </b></td><td>'.$data['clas'].'</td></tr>'
                        . '<tr><td><b>Father Name: </b></td><td>'.$data['father_name'].'</td></tr>'
                        . '<tr><td><b>Mother Name: </b></td><td>'.$data['mother_name'].'</td></tr>'
                        . '<tr><td><b>Contact Number: </b></td><td>'.$data['phone'].'</td></tr>'
                        . '<tr><td><b>Contact Email: </b></td><td>'.$data['email'].'</td></tr></table>'
                        . '<br /><br /><b>Note: </b>Please do not reply of this email.<br /><br />--<br />Warm Regards,<br />Modern Era Support.';
                $mail = new Zend_Mail();
                $mail->setBodyHtml($body);
                $mail->setSubject($subject);
                $mail->addTo('akhilkumarit@gmail.com');
                $mail->setFrom('alert@moderneraconvent.com', 'ModernEra Support');
                $mail->send();
                $sess->msg = 'Your admission enquiry submitted successfully. We\'ll revert back you shortly';
            } else {
                $sess->error = 'Unable to process your request. Please try again.';
            }
        }
    }

}
