<?php

class AjaxController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
        $this->_helper->layout()->disableLayout();
    }

    public function indexAction()
    {
        
    }
    
    public function userAction()
    {
        $obj_user = new Application_Model_UserLogic(-1);
        $this->view->results = $obj_user->fetchOrdered();
    }

    public function roleAction()
    {
        $obj_role = new Application_Model_RoleLogic(-1);
        $this->view->results = $obj_role->fetchOrdered();
    }
    
    public function categoryByParentAction()
    {
        $id = $this->_getParam('id');
        $obj_cat = new Application_Model_CategoryLogic(-1);
        $this->view->results = $obj_cat->getSubCategory($id);
    }
    
    public function listCategoryMoreAction()
    {
        $id = $this->_getParam('id');
        $obj_cat = new Application_Model_CategoryLogic(-1);
        $this->view->results = $obj_cat->getParentCategory();
    }

    public function forgetAction()
    {
        $userId = $this->_getParam('userId');
        $obj_user = new Application_Model_UserLogic(-1);
        if($obj_user->checkUserIdExist($userId)) {
            $user = $obj_user->getUserByUserId($userId);
            $otp = Application_Model_Util_Encrypt::getRandomString();
            $subject = Application_Model_Cache_Config::getConfig('SITE_NAME')." Password Assistance.";
            $body = 'Dear '.$user->get_user_name().',<br>You have requested to reset your password. For resetting the password you must enter an OTP (Please note OTP is case sensitive thing.). Please find the enclosed OTP with this email.<br><br><b>One Time Password: '.$otp.'</b><br><br><br>Support Team,<br />Select Surveyors Private Limited.'.Application_Model_Cache_Config::getConfig('EMAIL_FOOTER');
            $usess = new Zend_Session_Namespace('user');
            $usess->user_otp = $otp;
            $email = new Application_Model_Email_Util();
            $email->send($user->get_user_email(), $subject, $body);
            echo 'We have send an email with the OTP.';
        }else {
            echo 'Sorry, we did not find the User Id. Please contact to administrator.';
        }
        
    }
    
    public function searchAction()
    {
        $results = array();
        $term = $this->_getParam('term');
        $obj_list = new Application_Model_View_ListLogic(-1);
        $i=0;
        foreach($obj_list->searchWords($term) as $r) {
            $i+=1;
            array_push($results, array('id'=>$i, 'label'=>$r['title'], 'value'=>$r['title']));
        }
        echo json_encode($results);
    }
    
}

