<?php

class AlumniController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
    }

    public function indexAction()
    {
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', 'latest, events, modern, era, open, convent, school, institute, janakpuri, occasions, celebrations, alert, admission, calendar'); 
        $layout->assign('meta_desc', 'Modern Era School providing best support to our students. With this page you can download transfer certificates.');
        $layout->assign('page_title', 'Alumni Registration');
    }
    
    public function registerAction() {
        $this->_helper->layout()->disableLayout();
        $status = false;
        $message="";
        if($this->getRequest()->isPost()) {
            $data = $this->getRequest()->getPost();
            $obj_alumni = new Application_Model_AlumniLogic(-1);
            $obj_alumni->set_alumni_admission_num($data['alumni_admission_num']);
            $obj_alumni->set_alumni_student_name($data['alumni_student_name']);
            $obj_alumni->set_alumni_father_name($data['alumni_father_name']);
            $obj_alumni->set_alumni_dob($data['alumni_dob']);
            $obj_alumni->set_alumni_gender($data['alumni_gender']);
            $obj_alumni->set_alumni_address($data['alumni_address']);
            $obj_alumni->set_alumni_email($data['alumni_email']);
            $obj_alumni->set_alumni_phone($data['alumni_phone']);
            $obj_alumni->set_alumni_mobile($data['alumni_mobile']);
            $obj_alumni->set_alumni_pass_year($data['alumni_pass_year']);
            $obj_alumni->set_alumni_stream($data['alumni_stream']);
            $obj_alumni->set_alumni_percent($data['alumni_percent']);
            $obj_alumni->set_alumni_degree($data['alumni_degree']);
            $obj_alumni->set_alumni_current_status($data['alumni_current_status']);
            $obj_alumni->set_alumni_remarks($data['alumni_remarks']);
            $obj_alumni->set_alumni_status('A');
            $obj_alumni->set_alumni_updated_by(0);
            $obj_alumni->set_alumni_created_by(0);
            $obj_alumni->save();
            $obj_al = new Application_Model_AlumniLogic($obj_alumni->getAdapter()->lastInsertId());
            if($obj_al->get_alumni_admission_num() == $data['alumni_admission_num']) {
                $status = true;
                $message = 'SUCCESS!!!';
            }else {
                $status = false;
                $message = 'Something went wrong, please contact to administrator.';
            }
            $response = array('status'=>$status, 'message'=>$message);
            echo Zend_Json::encode($response);
        }
    }
}