<?php

class BlogController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
    }

    public function indexAction()
    {
        $category = urldecode($this->_getParam('cat'));
        $month = urldecode($this->_getParam('month'));
        
        $obj_blog = new Application_Model_BlogLogic(-1);
        $this->view->categories = $obj_blog->getActiveBlogCategory();
        $this->view->recentBlogs = $obj_blog->getActiveBlogs(4);
        $this->view->archive = $obj_blog->getDistinctBlogMonthYear();
        
        if(!empty($category)) {
            $obj_cat = new Application_Model_CategoryLogic(-1);
            $catId = $obj_cat->getIdByTitle($category);
            $this->view->cat = new Application_Model_CategoryLogic($catId);
        }else {
            $catId = 0;
        }
        
        $cur_page=1;
        if($this->_getParam("page")!=null)
            $cur_page=(int)$this->_getParam("page");
        
        if($this->getRequest()->isPost()) {
            $results = $obj_blog->searchActiveBlogSelect($this->_getParam('q'));
        }else if(!empty($month)) {
            $results = $obj_blog->getActiveArchiveBlogSelect($month);
            $this->view->month = date('M Y', strtotime('01-'.$month));
            $this->view->monthKey = $month;
        }else {
            $results = $obj_blog->getActiveBlogsSelect($catId);
        }
        
        $adapter = new Zend_Paginator_Adapter_DbSelect($results);
        
        $paginator = new  Zend_Paginator($adapter);
        
        
        $paginator->setItemCountPerPage(20);
        $paginator->setCurrentPageNumber($cur_page);
        
        
        $this->view->paginator = $paginator;
        
        Zend_Paginator::setDefaultScrollingStyle("Sliding");
        Zend_View_Helper_PaginationControl::setDefaultViewPartial(
        "pagination.phtml"
        );
    }
    
    public function viewAction()
    {
        $url = urldecode($this->_getParam('url'));
        $obj_blog = new Application_Model_BlogLogic(-1);
        $id = $obj_blog->getBlogIdByUrl($url);
        if($id > 0) {
            $this->view->blog = $blog = new Application_Model_BlogLogic($id);
            $this->view->cat = $category = new Application_Model_CategoryLogic($blog->get_blog_category());
            $this->view->categories = $obj_blog->getActiveBlogCategory();
            $this->view->recentBlogs = $obj_blog->getActiveBlogs(4);
            $this->view->archive = $obj_blog->getDistinctBlogMonthYear();
        }else {
            $this->_redirect('blog');
        }
    }
    
}