<?php

class CategoryController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
    }

    public function indexAction()
    {
        $category = urldecode($this->_getParam('cat'));
        $loc = urldecode($this->_getParam('loc'));
        
        $obj_cat = new Application_Model_CategoryLogic(-1);
        $this->view->categories = $obj_cat->getCategoryByType(Application_Model_CategoryLogic::CATEGORY_TYPE_FEATURE);
        
        $catId = $obj_cat->getIdByTitle($category);
        $this->view->cat = new Application_Model_CategoryLogic($catId);
        
        $obj_blog = new Application_Model_BlogLogic(-1);
        $this->view->blogs = $obj_blog->getActiveBlogs(4);
        
        $obj_list = new Application_Model_ListLogic(-1);
        $this->view->locations = $obj_list->getListingLocationByCategory($catId);
        
        $cur_page=1;
        if($this->_getParam("page")!=null)
        
        $cur_page=(int)$this->_getParam("page");
        
        $results = $obj_list->getListingsByCategory($catId, $loc);
        
        $adapter = new Zend_Paginator_Adapter_DbSelect($results);
        
        $paginator = new  Zend_Paginator($adapter);
        
        
        $paginator->setItemCountPerPage(10);
        $paginator->setCurrentPageNumber($cur_page);
        
        
        $this->view->paginator = $paginator;
        
        Zend_Paginator::setDefaultScrollingStyle("Sliding");
        Zend_View_Helper_PaginationControl::setDefaultViewPartial(
        "pagination.phtml"
        );
    }
    
}