<?php

class EventController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
    }

    public function indexAction()
    {
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', 'latest, events, modern, era, open, convent, school, institute, janakpuri, occasions, celebrations, alert, admission, calendar'); 
        $layout->assign('meta_desc', 'You can check the latest news, notice and announcement about R. K. Property Bindki Fatehpur.');
        $layout->assign('page_title', 'Events');
        
    }
    
    public function upcomingAction()
    {
        $cur_page=1;
        if($this->_getParam("page")!=null)
            $cur_page=(int)$this->_getParam("page");
        
        $obj_event = new Application_Model_EventsLogic(-1);
        
        $adapter = new Zend_Paginator_Adapter_DbSelect($obj_event->selectLimitOrdered(null));
        
        $paginator = new  Zend_Paginator($adapter);
        
        $paginator->setItemCountPerPage(20);
        $paginator->setCurrentPageNumber($cur_page);
        
        $this->view->paginator = $paginator;
        
        Zend_Paginator::setDefaultScrollingStyle("Sliding");
        Zend_View_Helper_PaginationControl::setDefaultViewPartial(
        "pagination.phtml"
        );
        
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', 'latest, events, modern, era, open, convent, school, institute, janakpuri, occasions, celebrations, alert, admission, calendar'); 
        $layout->assign('meta_desc', 'You can check the latest news, notice and announcement about R. K. Property Bindki Fatehpur.');
        $layout->assign('page_title', 'Events');
        
    }
    
    public function viewAction()
    {
        $title = $this->_getParam('url');
        
        $obj_events = new Application_Model_EventsLogic(-1);
        $obj_events->getEventByUrl(urldecode($title));
        $this->view->event = $obj_events;
        
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', 'latest, events, modern, era, open, convent, school, institute, janakpuri, occasions, celebrations, alert, admission, calendar'.  str_replace(' ', ', ', $obj_events->get_event_title())); 
        $layout->assign('meta_desc', $obj_events->get_event_intro_text());
        $layout->assign('page_title', $obj_events->get_event_title());
    }
    
    public function jsonAction()
    {
        $this->_helper->layout()->disableLayout();
        $start = date('Y-m-d', ($this->_getParam('start'))); 
        $end = date('Y-m-d', ($this->_getParam('end'))); 

        $obj_events = new Application_Model_EventsLogic(-1);
        $evnts = $obj_events->fetchOrdered($start, $end);

        $baseUrl = new Zend_View_Helper_BaseUrl();

        $events = array();

        foreach($evnts as $event)
        {
            $url = $baseUrl->baseUrl('event/'. Application_Model_Util_Util::convertToUrl($event->event_url));
            $className = 'fc-event-grey';

            $final = array();
            $final['id'] = $event->id;
            $final['title'] = $event->event_title;
            $final['start'] = $event->event_start;
            $final['end'] = $event->event_end;
            $final['allDay'] = true;
            $final['url'] = $url;
            $final['className'] = $className;
            array_push($events, $final);
        }
        //Zend_Debug::dump($events);
        echo json_encode($events);
    }

}
