<?php

class GalleryController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
    }

    public function indexAction()
    {
        $obj_album = new Application_Model_AlbumLogic(-1);
        $this->view->albums = $obj_album->fetchOrdered();
        
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', 'album, image, svs, gallery, bindki, swami, vigyananand, saraswati, higher, secondary, school, college, pictures, images, best'); 
        $layout->assign('meta_desc', 'You can check the latest images and videos of SVS (Swami Vigyananand Saraswati Higher Secondary School) here.');
        $layout->assign('page_title', 'Gallery - Swami Vigyananand Saraswati Higher Secondary School');
        
    }
    
    public function itemsAction()
    {
        $title = $this->_getParam('title');
        
        $obj_album = new Application_Model_AlbumLogic(-1);
        $this->view->album = $album = new Application_Model_AlbumLogic($obj_album->fetchIdByUrl($title));
        
        $items = array();
        
        $obj_image = new Application_Model_ImageLogic(-1);
        foreach($obj_image->fetchOrdered($album->get_id()) as $item) {
            $i = array("date"=>$item->image_created_date, "title"=>$item->image_title, "path"=>$item->image_path, "type"=>"I");
            array_push($items, $i);
        }
        
        $obj_video = new Application_Model_VideoLogic(-1);
        foreach($obj_video->fetchOrdered($album->get_id()) as $item) {
            $v = array("date"=>$item->video_created_date, "title"=>$item->video_title, "path"=>$item->video_code, "type"=>"V");
            array_push($items, $v);
        }
        
        $sortColumn = array_column($items, 'date');
        //https://stackoverflow.com/questions/1597736/how-to-sort-an-array-of-associative-arrays-by-value-of-a-given-key-in-php
        array_multisort($sortColumn, SORT_DESC, $items);

        $this->view->items = $items;

        $layout = $this->_helper->layout();
        $layout->assign('meta_key', str_replace(' ', ', ', $album->get_album_desc())); 
        $layout->assign('meta_desc', $album->get_album_desc());
        $layout->assign('page_title', $album->get_album_title());
        
    }

}
