<?php
/**
 * Zend controller for Perform all action her such as add update delete or index list
 *
 * Cred build Img controller for control the requests for image routing.
 *
 * @package asit.eyt.credbuild.controllers
 * @name Img Controller
 * @filesource application/controllers
 * @author Akhil Kumar
 * @copyright Credbuild
 * @version 1.0
 * @license Credbuild
 * @subpackage Zend_Controllers
 */
class ImgController extends Zend_Controller_Action
{

    /*
     * init action stand for disabling the current layout and off the default rendering.
     */
    public function init()
    {
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender(true);
    }

    /*
     * indexAction stand for image rendering with the routing of the path
     */
    public function indexAction()
    {
        // action body
        $options['nestSeparator'] = ':';
        //$config=new Application_Model_Config();
        $type='';
        $sub_type='';
        $sub_sub_type='';
        if($this->getRequest()->getParam('folder')!=null){
            $type=$this->getRequest()->getParam('folder');
        }

        if($this->getRequest()->getParam('sub_folder')!=null){
            $sub_type=$this->getRequest()->getParam('sub_folder');
        }
        if($this->getRequest()->getParam('sub_sub_folder')!=null){
            $sub_sub_type=$this->getRequest()->getParam('sub_sub_folder');
        }
        $fname=$this->getRequest()->getParam('filename');
        
        $this->getResponse()->setHeader('Content-Type','image');
        $this->getResponse()->setHeader('Cache-Control','max-age=290304000, public');
        
        $upload_folder = Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME');
        if($type!=''){
            $full_path = $upload_folder . '/' . $type. '/' . $fname;
            if($sub_type!=''){
                $full_path = $upload_folder . '/' . $type . '/' . $sub_type . '/' . $fname;                
            }
            if($sub_sub_type!=''){
                $full_path = $upload_folder . '/' . $type . '/' . $sub_type . '/' . $sub_sub_type . '/' . $fname;
            }
        }
        else
            $full_path = $upload_folder. '/' . $fname;
        
        if(!file_exists($full_path)){
           $this->badAction();
        }
        readfile($full_path);
    }


    /*
     * bad action perform that request when image is not available into the server.
     */
    public function badAction(){
        $this->getResponse()->setHeader('Content-Type','image/jpeg');
        echo hello;
    }


}

