<?php

class IndexController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
    }

    public function indexAction()
    {
        $layout = $this->_helper->layout();
        $layout->setLayout('home');
        $layout->assign('meta_key', 'delicious, food, hunger, daddy, search, result, dish, quality, ambience, value, money, service, night, life, features'); 
        $layout->assign('meta_desc', 'We believe that a unique experience can make your restaurant\'s food taste better. When there are so many dining choices and new restaurants seem to pop up daily, you need an edge to compete.');
        $layout->assign('page_title', 'Welcome to '.Application_Model_Cache_Config::getConfig('SITE_NAME'));
    }
    
    public function listAction()
    {
        
    }
    
    public function iconAction()
    {
        
    }
    
    public function contactAction() {
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', 'delicious, food, hunger, daddy, search, result, dish, quality, ambience, value, money, service, night, life, features'); 
        $layout->assign('meta_desc', 'We believe that a unique experience can make your restaurant\'s food taste better. When there are so many dining choices and new restaurants seem to pop up daily, you need an edge to compete.');
        $layout->assign('page_title', 'Contact to '.Application_Model_Cache_Config::getConfig('SITE_NAME'));
    }
    
    public function contactStoreAction()
    {
        $this->_helper->layout()->disableLayout();
        
        if($this->getRequest()->isPost()) {
            $errors = array();
            $data = $this->getRequest()->getPost();
            if(empty($data['contact_name'])) {
                array_push($errors, 'Name can not be blank.');
            }
            if(empty($data['contact_email']) && empty($data['contact_phone'])) {
                array_push($errors, 'Contact information shoud be provided.');
            }
            if(empty($data['contact_query'])) {
                array_push($errors, 'Query/Feedback can not be blank.');
            }
            $name = $data['contact_name'];
            $email = $data['contact_email'];
            $phone = (!empty($data['contact_phone'])) ? $data['contact_phone'] : '';
            $subject = (!empty($data['contact_subject'])) ? $data['contact_subject'] : '';
            $query = $data['contact_query'];
            if(count($errors) == 0) {
                $obj_contact = new Application_Model_Contact(-1);
                $obj_contact->set_contact_name($name);
                $obj_contact->set_contact_email($email);
                $obj_contact->set_contact_phone($phone);
                $obj_contact->set_contact_subject($subject);
                $obj_contact->set_contact_query($query);
                $obj_contact->set_contact_created_by(0);
                $obj_contact->set_contact_updated_by(0);
                $obj_contact->set_contact_status('A');
                $obj_contact->save();
            }
            
            $response = Zend_Json::encode(array('is_errors'=> count($errors), 'info'=>(count($errors) == 0) ? 'success' : 'error', 'message'=>(count($errors) == 0) ? 'Your query has been submitted successfully.' : implode('<br />', $errors)));
            echo $response;
                   
        }
    }
    
    public function registerAction()
    {
        $this->_helper->layout()->disableLayout();
        if($this->getRequest()->isPost()){
            $data = $this->getRequest()->getPost();
            $uname = $data['username'];
            $uid = $data['userid'];
            $email = $data['email'];
            $mobile = $data['mobile'];
            $paswd = $data['password'];
            $status = true;
            $obj_user = new Application_Model_UserLogic(-1);
            $errors = array();
            if($obj_user->checkUserIdExist($uid)) {
                $status = false;
                array_push($errors, "User ID already exist.");
            }
            if($obj_user->checkEmailExist($email)) {
                $status = false;
                array_push($errors, "Email ID already exist.");
            }
            if($obj_user->checkMobileExist($mobile)) {
                $status = false;
                array_push($errors, "Mobile Number already exist.");
            }
            if(strlen($paswd) < 8) {
                $status = false;
                array_push($errors, "Password must have minimum 8 characters.");
            }
            
            if($status) {
                $obj_user->set_user_id($uid);
                $obj_user->set_user_password(sha1($paswd));
                $obj_user->set_user_name($uname);
                $obj_user->set_user_email($email);
                $obj_user->set_user_mobile($mobile);
                $obj_user->set_user_dob(date('Y-m-d'));
                $obj_user->set_user_gender('O');
                $obj_user->set_user_role(Application_Model_Cache_Config::getConfig('SITE_USER_ROLE'));
                $obj_user->set_user_status('A');
                $obj_user->set_user_token(md5($uid));
                $obj_user->set_user_updated_by(0);
                $obj_user->set_user_created_by(0);
                $obj_user->save();
                
                $this->view->msg = "You have successfully registered";
            }else {
                $this->view->errors = $errors;
            }
        }
    }

    public function loginAction()
    {
        $this->_helper->layout()->disableLayout();
        $response = array('status'=>false, 'message'=>'You are not authorize person to login.');
        if($this->getRequest()->isPost()) {
            $uname = $this->_getParam('user_id');
            $paswd = $this->_getParam('user_password');
            $obj_auth = new Application_Model_UserLogic(-1);
            $check = $obj_auth->is_student_authenticated($uname, $paswd);
            /*if($check){
                $obj_user = new Application_Model_UserLogic(-1);
                $logginUser = $obj_user->getLoggedInUser();
                $user = ($logginUser != null) ? new Application_Model_UserLogic($logginUser->get_id()) : null;
                if($user->get_user_status() == 'B') {
                    $obj_user->logout();
                    $sess = new Zend_Session_Namespace('msg');
                    $sess->error = "Your account has been blocked. Please contact to administrator.";
                    $this->_redirect('index');
                }
                else {
                    $sess = new Zend_Session_Namespace('msg');
                    $sess->msg = "You have successfully logged in.";
                    $this->_redirect('');
                }
            }
            else{
                $sess = new Zend_Session_Namespace('msg');
                $sess->error = "Wrong User ID or Password, Please Reenter!";
                $this->_redirect('index');
            }*/
            if($check) {
                $response = array('status'=>true, 'message'=>'You have successfully login.');
            }
        }
        /* else {
            $sess = new Zend_Session_Namespace('msg');
            $sess->error = "Please enter valid data!";
            $this->_redirect('index'); 
            
        } */
        echo Zend_Json::encode($response);
    }
    
    public function forgetAction() 
    {
        $this->_helper->layout()->disableLayout();
        if($this->getRequest()->isPost()){
            $data = $this->getRequest()->getPost();
            $uname = $this->_getParam('user_id');
            $paswd = $this->_getParam('user_password');
            $repaswd = $this->_getParam('user_repassword');
            $otp = $this->_getParam('user_otp');
            $usess = new Zend_Session_Namespace('user');
            $sess = new Zend_Session_Namespace('msg');
            if($otp == $usess->user_otp) {
                $obj_user = new Application_Model_UserLogic(-1);
                $resetUser = $obj_user->getUserByUserId($uname);
                if($resetUser->get_user_status() == 'B') {
                    $sess->error = "Your account has been blocked. Please contact to administrator.";
                    $this->_redirect('index/forget');
                }
                else if($paswd != $repaswd) {
                    $sess->error = "Sorry Password and Re Password does not match.";
                }
                else {
                    $resetUser->set_user_password(sha1($paswd));
                    $resetUser->save();
                    $sess->msg = "You have successfully reset the password.";
                    $this->_redirect('index');
                }
            }
            else{
                $sess = new Zend_Session_Namespace('msg');
                $sess->error = "Sorry, OTP does not match!";
                $this->_redirect('index/forget');
            }
        }
        
    }
    
    public function logoutAction()
    {
        $auth = Zend_Auth::getInstance(); 
        if(!$auth->hasIdentity()){ 
           $sess = new Zend_Session_Namespace('msg');
           $sess->error = "You session already expired, Please login!";
           $this->_redirect("index");
        }
        $sess = new Zend_Session_Namespace('user');
        unset($sess->id);
        unset($sess->user_id);
        Zend_Session::namespaceUnset('user');
        $auth->clearIdentity();
        $sess = new Zend_Session_Namespace('msg');
        $sess->msg = "You have successfully logout.";
        $this->_redirect('index');
    }

    public function chpwdAction()
    {
        $auth = Zend_Auth::getInstance(); 
        if($auth->hasIdentity()){ 
            $chpwdForm = new Application_Form_Chpwd();
            $this->view->form = $chpwdForm;
            if($this->getRequest()->isPost()){
                $data=$this->getRequest()->getPost();    
                if($chpwdForm->isValid($data)){
                    $iden = new Zend_Session_Namespace('user');
                    $obj_login = new Application_Model_User($iden->id);
                    $cred = $obj_login->get_user_password();
                    $oldpwd = $chpwdForm->old_pwd->getValue();
                    $newpwd = $chpwdForm->new_pwd->getValue();
                    $repwd = $chpwdForm->re_new_pwd->getValue();
                    if($cred == sha1($oldpwd)){
                        if($newpwd == $repwd){
                            $mpwd = sha1($newpwd);
                            $obj_login->set_user_password($mpwd);
                            $obj_login->save();
                            $sess = new Zend_Session_Namespace('msg');
                            $sess->msg = "You Have Successfully Change Your Password!!!";
                            $this->_redirect('index/chpwd');
                        }
                        else{
                            $sess = new Zend_Session_Namespace('msg');
                            $sess->error = "Your Password Not Match!!!";
                            $this->_redirect('index/chpwd');
                        }
                    }
                    else{
                        $sess = new Zend_Session_Namespace('msg');
                        $sess->error = "You Enter Wrong Old Password!!!";
                        $this->_redirect('index/chpwd');
                    }
                }    
            }
        } 
        else { 
           $sess = new Zend_Session_Namespace('msg');
           $sess->error = "You are not authorize person, Please login!";
           $this->_redirect("index/index");
        }
    }
    
}

