<?php

class ListController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
    }

    public function indexAction()
    {
        $title = urldecode($this->_getParam('url'));
        
        $this->view->listLogic = $obj_list = new Application_Model_ListLogic(-1);
        $listId = $obj_list->getListIdByUrl($title);
        
        $this->view->list = $list = new Application_Model_View_ListLogic($listId);
        $obj_list_img = new Application_Model_ListImageLogic(-1);
        $this->view->listImage = $obj_list_img->getActiveImage($listId);
        $this->view->cat = $obj_cat = new Application_Model_CategoryLogic($list->get_list_category());
        $obj_review = new Application_Model_ReviewLogic(-1);
        $this->view->reviews = $obj_review->getReviewsByList($list->get_id());
        
        $obj_list = new Application_Model_ListLogic($list->get_id());
        $obj_list->set_list_visitors((int)$obj_list->get_list_visitors() + 1);
        $obj_list->save();
        
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', $list->get_list_tags()); 
        $layout->assign('meta_desc', $list->get_list_short_desc());
        $layout->assign('page_title', $list->get_list_title());
        
        $layout->assign('meta_url', Application_Model_Cache_Config::getConfig('SITE_URL').$list->get_list_url()); 
        $layout->assign('meta_image', Application_Model_Cache_Config::getConfig('SITE_URL').'img/'.Application_Model_Cache_Config::getConfig('LIST_FOLDER').'/'.$list->get_list_image()); 
        $layout->assign('meta_created', $list->get_list_created_date()); 
        $layout->assign('meta_updated', $list->get_list_updated_date());
        
        $this->view->listings = $list->getRelatedListing($list->get_list_category());
    }
    
    public function viewAction()
    {
        $url = urldecode($this->_getParam('url'));
        $obj_blog = new Application_Model_BlogLogic(-1);
        $id = $obj_blog->getBlogIdByUrl($url);
        if($id > 0) {
            $this->view->blog = $blog = new Application_Model_BlogLogic($id);
            $this->view->cat = $category = new Application_Model_CategoryLogic($blog->get_blog_category());
            $this->view->categories = $obj_blog->getActiveBlogCategory();
            $this->view->recentBlogs = $obj_blog->getActiveBlogs(4);
            $this->view->archive = $obj_blog->getDistinctBlogMonthYear();
        }else {
            $this->_redirect('blog');
        }
    }
    
    public function filterAction()
    {
        $where = null;
        $obj_list = new Application_Model_View_ListLogic(-1);
        if(!empty($this->_getParam('cat'))) {
            $subHead = 'Category';
            $head = $this->_getParam('cat');
            $count = 20;
            $obj_category = new Application_Model_CategoryLogic(-1);
            $obj_cat = new Application_Model_CategoryLogic($obj_category->getIdByTitle($this->_getParam('cat')));
            $where = $obj_list->getListingsByCategory($obj_cat->get_id());
            $isPaginationReuired = ($count > 20) ? true : false;
            $title = $obj_cat->get_category_title().' Posts';
        }
        if(!empty($this->_getParam('ct'))) {
            $subHead = 'City';
            $head = $this->_getParam('ct');
            $count = 20;
            $obj_ct = new Application_Model_CityLogic(-1);
            $obj_city = new Application_Model_CityLogic($obj_ct->getIdByTitle($this->_getParam('ct')));
            $where = $obj_list->getListingsByCity($obj_city->get_id());
            $isPaginationReuired = ($count > 20) ? true : false;
            $title = $obj_city->get_city_name() .' Posts';
        }
        if($this->getRequest()->isPost() && !empty($this->_getParam('query'))) {
            $subHead = 'Search';
            $head = $this->_getParam('query');
            $where = $obj_list->searchListings($this->_getParam('query'));
            $count = count($obj_list->fetchAll($where));
            $isPaginationReuired = false;
            $title = 'Search Results';
        }
        if($this->getRequest()->isPost() && empty($this->_getParam('query'))) {
            $data = $this->getRequest()->getPost();
            $subHead = 'Search';
            $head = 'Filtered Results';
            $where = $obj_list->filterListings($data);
            $count = count($obj_list->fetchAll($where));
            $isPaginationReuired = false;
            $this->view->data = $data;
            $title = 'Search Results';
        }
        $cur_page=1;
        if($this->_getParam("page")!=null)
        
        $cur_page=(int)$this->_getParam("page");
        
        $adapter = new Zend_Paginator_Adapter_DbSelect($where);
        
        $paginator = new  Zend_Paginator($adapter);
        
        
        $paginator->setItemCountPerPage($count);
        $paginator->setCurrentPageNumber($cur_page);
        
        
        $this->view->paginator = $paginator;
        
        Zend_Paginator::setDefaultScrollingStyle("Sliding");
        Zend_View_Helper_PaginationControl::setDefaultViewPartial(
        "pagination.phtml"
        );
        
        $this->view->subHead = $subHead;
        $this->view->head = $head;
        $this->view->count = $count;
        $this->view->isPaginationRequired = $isPaginationReuired;
        $obj_cat = new Application_Model_CategoryLogic(-1);
        $this->view->categories = $obj_cat->getParentCategory();
        $this->view->amenities = Application_Model_ListMetaLogic::$amenities;
        $obj_city = new Application_Model_CityLogic(-1);
        $this->view->city = $obj_city->fetchOrdered();
        $this->view->targets = Application_Model_ListMetaLogic::$target;
        
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', 'delicious, food, hunger, daddy, search, result, dish, quality, ambience, value, money, service, night, life, features, '. str_replace(' ', ', ', $title)); 
        $layout->assign('meta_desc', 'Explore the dishes from best restaurents. We are sharing the dish quality, image for search with oour broad'.$title);
        $layout->assign('page_title', $title);
        
    }
    
    public function reviewAction()
    {
        if($this->getRequest()->isPost()) {
            $data = $this->getRequest()->getPost();
            $listId = $data['list'];
            $title = $data['review-title'];
            $message = $data['review-message'];
            $rating = $data['rating'];
            
            $user = new Application_Model_UserLogic(-1);
            
            $obj_review = new Application_Model_ReviewLogic(-1);
            $obj_review->set_review_list($listId);
            $obj_review->set_review_user($user->getLoggedInUserId());
            $obj_review->set_review_score($rating);
            $obj_review->set_review_subject($title);
            $obj_review->set_review_body($message);
            $obj_review->set_review_status('A');
            $obj_review->set_review_updated_by($user->getLoggedInUserId());
            $obj_review->set_review_created_by($user->getLoggedInUserId());
            $obj_review->save();
            
            $obj_list = new Application_Model_ListLogic($listId);
            $review = $obj_review->getAvgReview($listId);
            $obj_list->set_list_review_score(round($review['score']));
            $obj_list->set_list_review_total($review['total']);
            $obj_list->save();
            
            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Review has been submitted Successfully!!!";
            $this->_redirect($obj_list->get_list_url());
        }else {
            $this->_redirect('');
        }
    }
    
    public function messageAction()
    {
        if($this->getRequest()->isPost()) {
            $data = $this->getRequest()->getPost();
            $subject = $data['subject'];
            $message = $data['message'];
            $user = $data['user'];
            $list = $data['list'];
            $obj_list = new Application_Model_ListLogic($list);
            $obj_message = new Application_Model_MessageLogic(-1);
            $obj_message->sendMessage($user, $subject, $message);
            
            $sess = new Zend_Session_Namespace("msg");
            $sess->msg = "Review has been submitted Successfully!!!";
            $this->_redirect($obj_list->get_list_url());
        }else {
            $this->_redirect('');
        }
    }
    
    public function reportAction()
    {
        $enc = new Application_Model_Util_Encrypt();
        $id = $enc->showHiddenContent($this->_getParam('abuse'));
        $obj_list = new Application_Model_ListLogic($id);
        $obj_list->set_list_abuse($obj_list->get_list_abuse() + 1);
        $obj_list->save();
        
        $this->_redirect($obj_list->get_list_url());
    }
    
}