<?php

class NewsController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
    }
    
    public function indexAction()
    {
        $cur_page=1;
        if($this->_getParam("page")!=null)
            $cur_page=(int)$this->_getParam("page");
        
        $obj_news = new Application_Model_NewsLogic(-1);
        
        $adapter = new Zend_Paginator_Adapter_DbSelect($obj_news->getActiveNewsSelect());
        
        $paginator = new  Zend_Paginator($adapter);
        
        
        $paginator->setItemCountPerPage(20);
        $paginator->setCurrentPageNumber($cur_page);
        
        
        $this->view->paginator = $paginator;
        
        Zend_Paginator::setDefaultScrollingStyle("Sliding");
        Zend_View_Helper_PaginationControl::setDefaultViewPartial(
        "pagination.phtml"
        );
        
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', 'latest, events, modern, era, open, convent, school, institute, janakpuri, occasions, celebrations, alert, admission, calendar'); 
        $layout->assign('meta_desc', 'You can check the latest news, notice and announcement about R. K. Property Bindki Fatehpur.');
        $layout->assign('page_title', 'Latest News');
    }

    public function viewAction()
    {
        $url = urldecode($this->_getParam('url'));
        
        $obj_news = new Application_Model_NewsLogic(-1);
        $obj_news->getNewsByUrl($url);
        $this->view->news = $obj_news;
        
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', $obj_news->get_news_meta_key()); 
        $layout->assign('meta_desc', $obj_news->get_news_meta_desc());
        $layout->assign('page_title', $obj_news->get_news_title());
    }
    
    
}