<?php

class PageController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
    }

    public function indexAction()
    {
        echo $url = urldecode($this->_getParam('url'));
        
        $obj_page = new Application_Model_PageLogic(-1);
        $obj_page->getPageByUrl($url);
        if($obj_page->get_id() > 0) {
            $this->view->page = $obj_page;
        }else {
            throw new Zend_Controller_Action_Exception('Sorry, Your requested url is not exist or permanently removed.', 404);
        }
        
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', $obj_page->get_page_meta_key()); 
        $layout->assign('meta_desc', $obj_page->get_page_meta_desc());
        $layout->assign('page_title', $obj_page->get_page_title());
    }
    
    public function circularAction()
    {
        $cur_page=1;
        if($this->_getParam("page")!=null)
            $cur_page=(int)$this->_getParam("page");
        
        $obj_circular = new Application_Model_CircularLogic(-1);
        
        $adapter = new Zend_Paginator_Adapter_DbSelect($obj_circular->selectActiveCirculars());
        
        $paginator = new  Zend_Paginator($adapter);
        
        
        $paginator->setItemCountPerPage(20);
        $paginator->setCurrentPageNumber($cur_page);
        
        
        $this->view->paginator = $paginator;
        
        Zend_Paginator::setDefaultScrollingStyle("Sliding");
        Zend_View_Helper_PaginationControl::setDefaultViewPartial(
        "pagination.phtml"
        );
        
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', 'latest, events, modern, era, open, convent, school, institute, janakpuri, occasions, celebrations, alert, admission, calendar'); 
        $layout->assign('meta_desc', 'You can check the latest news, notice and announcement about R. K. Property Bindki Fatehpur.');
        $layout->assign('page_title', 'Latest News');
    }
    
    public function downloadAction()
    {
        $cur_page=1;
        if($this->_getParam("page")!=null)
            $cur_page=(int)$this->_getParam("page");
        
        $obj_download = new Application_Model_DownloadLogic(-1);
        
        $adapter = new Zend_Paginator_Adapter_DbSelect($obj_download->selectActiveDownloads());
        
        $paginator = new  Zend_Paginator($adapter);
        
        
        $paginator->setItemCountPerPage(20);
        $paginator->setCurrentPageNumber($cur_page);
        
        
        $this->view->paginator = $paginator;
        
        Zend_Paginator::setDefaultScrollingStyle("Sliding");
        Zend_View_Helper_PaginationControl::setDefaultViewPartial(
        "pagination.phtml"
        );
        
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', 'latest, events, modern, era, open, convent, school, institute, janakpuri, occasions, celebrations, alert, admission, calendar'); 
        $layout->assign('meta_desc', 'You can check the latest news, notice and announcement about R. K. Property Bindki Fatehpur.');
        $layout->assign('page_title', 'Latest News');
    }
    
}