<?php

class TcController extends Zend_Controller_Action
{

    public function init()
    {
        /* Initialize action controller here */
    }

    public function indexAction()
    {
        $layout = $this->_helper->layout();
        $layout->assign('meta_key', 'latest, events, modern, era, open, convent, school, institute, janakpuri, occasions, celebrations, alert, admission, calendar'); 
        $layout->assign('meta_desc', 'Modern Era School providing best support to our students. With this page you can download transfer certificates.');
        $layout->assign('page_title', 'Transfer Certificates');
    }
    
    public function downloadAction() {
        $this->_helper->layout()->disableLayout();
        $status = false;
        $message="";
        $url = null;
        if($this->getRequest()->isPost()) {
            $sid = $this->_getParam('student_id');
            if(empty($sid)) {
                $status = false;
                $message = "Sorry, you have to provide student id for download tc.";
            }
            $obj_tc = new Application_Model_TcLogic(-1);
            $tc = $obj_tc->getStudentTc($sid);
            if(null == $tc) {
                $status = false;
                $message = "Sorry, we are not found tc with given student id or invalid student id.";
            }else {
                $status = true;
                $obj_tcs = new Application_Model_TcLogic($tc['id']);
                $obj_tcs->set_tc_download($obj_tcs->get_tc_download() + 1);
                $url = Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME').'/tc/'.$obj_tcs->get_tc_file();
                $message = 'SUCCESS!!!';
            }
            $response = array('status'=>$status, 'message'=>$message, 'url'=>$url);
            echo Zend_Json::encode($response);
        }
    }
}