<?php

class Application_Form_Activity extends Zend_Form
{

    /**
     * Method initialize form fields of asit_activitys table
     *
     * @var varchar activity_title
     * @var varchar activity_intro_text
     * @var text activity_desc
     * @var datetime activity_start
     * @var datetime activity_end
     * @var varchar activity_url
     * @var varchar activity_color
     * @var int activity_site
     * @var varchar activity_status
     * @var int activity_updated_by
     * @var timestamp activity_updated_date
     * @var int activity_created_by
     * @var timestamp activity_created_date
     */
    public function init()
    {
        
        echo '<script type="text/javascript">CKEDITOR.replace("activity_desc");'
        . 'function updateUrl(val) { $("#activity_url").val(val.toLowerCase().split(" ").join("-")); }</script>';
        
        $token = new Zend_Form_Element_Hash("token");
        
        $activity_date = new Zend_Form_Element_Text("activity_date");
        $activity_date->setLabel("Date")->setRequired(true)->setAttrib('class', 'datepick');
        
        $activity_title = new Zend_Form_Element_Text("activity_title");
        $activity_title->setLabel("Activity")->setRequired(true)->setAttrib('onchange', 'updateUrl(this.value);');
        
        $activity_desc = new Zend_Form_Element_Textarea("activity_desc");
        $activity_desc->setLabel("Description")->setRequired(true)->setAttrib('rows', 5);
        
        $activity_meta_key = new Zend_Form_Element_Textarea("activity_meta_key");
        $activity_meta_key->setLabel("Meta Key")->setRequired(true)->setAttrib('rows', 5);
        
        $activity_meta_desc = new Zend_Form_Element_Textarea("activity_meta_desc");
        $activity_meta_desc->setLabel("Meta Description")->setRequired(true)->setAttrib('rows', 5);
        
        $activity_url = new Zend_Form_Element_Text("activity_url");
        $activity_url->setLabel("URL")->setRequired(true)->setAttrib('readOnly', 'readOnly');
        
        $activity_status = new Zend_Form_Element_Radio("activity_status");
        $activity_status->setLabel("Status")->setRequired(true);
        $activity_status->addMultiOptions(Application_Model_Cache_Config::getConfig('STATUS_TYPE'));
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-blue4');
        
        $this->addElements(array($token,
        $activity_date,
        $activity_title,
        $activity_desc,
        $activity_meta_key,
        $activity_meta_desc,
        $activity_url,
        $activity_status,
        $save));
    }


}
