<?php

class Application_Form_Album extends Zend_Form
{

    /**
     * Method initialize form fields of asit_album table
     *
     * @var varchar album_title
     * @var varchar album_desc
     * @var varchar album_type
     * @var varchar album_url
     * @var int album_site
     * @var varchar album_status
     * @var int album_updated_by
     * @var timestamp album_updated_date
     * @var int album_created_by
     * @var timestamp album_created_date
     */
    public function init()
    {
        echo '<script type="text/javascript"> function updateUrl(val) { $("#album_url").val(val.toLowerCase().split(" ").join("-")); }</script>';
        
        $token = new Zend_Form_Element_Hash("token");
        
        $album_title = new Zend_Form_Element_Text("album_title");
        $album_title->setLabel("Title")->setRequired(true)->setAttrib('onchange', 'updateUrl(this.value);');
        
        $album_desc = new Zend_Form_Element_Textarea("album_desc");
        $album_desc->setLabel("Description")->setRequired(true)->setAttrib('rows', 5);
        
        $album_type = new Zend_Form_Element_Select("album_type");
        $album_type->setLabel("Type")->setRequired(true);
        $album_type->addMultiOption('', '-- Select Type --');
        $album_type->addMultiOption('I', 'Image');
        $album_type->addMultiOption('V', 'Video');
        
        $album_cover = new Zend_Form_Element_File("album_cover");
        $album_cover->setLabel("Image")->setRequired(true);
        $filename = date('d_M_y_H_i_s') .((null != $album_cover->getFileName(null, false)) ? $album_cover->getFileName(null, false) : '');
        $album_cover->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME').'/image/') 
            ->addFilter('Rename', $filename)
            ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE'))
            ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS'))
            ->setDescription('Only '.Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS').' files allowed');
        
        $album_url = new Zend_Form_Element_Text("album_url");
        $album_url->setLabel("URL")->setRequired(true);
        
        $album_status = new Zend_Form_Element_Radio("album_status");
        $album_status->setLabel("Status")->setRequired(true);
        $album_status->addMultiOptions(Application_Model_Cache_Config::getConfig('STATUS_TYPE'));
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-blue4');
        
        $this->addElements(array($token,
        $album_title,
        $album_desc,
        $album_cover,
        $album_url,
        $album_status,
        $save));
    }


}
