<?php

/**
 * Zend Form implementing a form to process the data.
 *
 * Asit blog Data Process via this form.
 *
 * @package Sakshi Infotech Code
 * @name Asit blog Form
 * @filesource application/model
 * @author Akhil Gupta
 * @copyright Sakshi Infotech
 * @version 1.0
 * @license Sakshi Infotech
 * @subpackage Zend_Forms
 */
class Application_Form_Blog extends Zend_Form
{

    /**
     * Method initialize form fields of asit_blog table
     *
     * @var varchar blog_title
     * @var varchar blog_image
     * @var varchar blog_short_desc
     * @var text blog_desc
     * @var varchar blog_url
     * @var varchar blog_meta_key
     * @var varchar blog_meta_desc
     * @var varchar blog_status
     * @var int blog_updated_by
     * @var timestamp blog_updated_date
     * @var int blog_created_by
     * @var timestamp blog_created_date
     */
    public function init()
    {
        $token = new Zend_Form_Element_Hash("token");
        $obj_base = new Zend_View_Helper_BaseUrl();
        
        echo "<script type='text/javascript'> CKEDITOR.replace( 'blog_desc',{fullPage : true,width: 650,filebrowserBrowseUrl :'".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserImageBrowseUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Type=Image&Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserFlashBrowseUrl :'".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Type=Flash&Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserUploadUrl  :'".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=File')."',
                filebrowserImageUploadUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=Image')."',
                filebrowserFlashUploadUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=Flash')."'});</script>";
        
        
        $blog_title = new Zend_Form_Element_Text("blog_title");
        $blog_title->setLabel("Title")->setRequired(true);
        
        $blog_category = new Zend_Form_Element_Select("blog_category");
        $blog_category->setLabel("Category")->setRequired(true);
        $obj_cat = new Application_Model_CategoryLogic(-1);
        $blog_category->addMultiOption('', '-- Select Category --');
        foreach($obj_cat->getBlogParentCategory() as $category) {
            $blog_category->addMultiOption($category->id, $category->category_title);
        }
        
        $blog_image = new Zend_Form_Element_File("blog_image");
        $blog_image->setLabel("Feature Image")->setRequired(true);
        $filename = date('d_M_y_H_i_s') . '_blog_' . ((null != $blog_image->getFileName(null, false)) ? $blog_image->getFileName(null, false) : '');
        $blog_image->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME') . '/' . Application_Model_Cache_Config::getConfig('BLOG_FOLDER') . '/')
            ->addFilter('Rename', $filename)
            ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE_LIBRARY'))
            ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS'))
            ->setDescription('Only ' . Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS') . ' files allowed');
        
        $blog_short_desc = new Zend_Form_Element_Textarea("blog_short_desc");
        $blog_short_desc->setLabel("Short Description")
            ->setRequired(true)
            ->setAttrib('rows', 5);
        
        $blog_desc = new Zend_Form_Element_Textarea("blog_desc");
        $blog_desc->setLabel("Description")->setRequired(true);
        
        $blog_meta_key = new Zend_Form_Element_Textarea("blog_meta_key");
        $blog_meta_key->setLabel("Meta Key")
            ->setRequired(true)
            ->setAttrib('rows', 5);
        
        $blog_meta_desc = new Zend_Form_Element_Textarea("blog_meta_desc");
        $blog_meta_desc->setLabel("Meta Description")
            ->setRequired(true)
            ->setAttrib('rows', 5);
        
        $blog_status = new Zend_Form_Element_Radio("blog_status");
        $blog_status->setLabel("Status")
            ->setRequired(true)
            ->setSeparator(' ');
        $blog_status->addMultiOption('A', 'Active');
        $blog_status->addMultiOption('E', 'Draft');
        $blog_status->addMultiOption('B', 'Block');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")
            ->setRequired(true)
            ->setAttrib('class', 'btn btn-blue4');
        
        $this->addElements(array(
            $token,
            $blog_title,
            $blog_category,
            $blog_image,
            $blog_short_desc,
            $blog_desc,
            $blog_meta_key,
            $blog_meta_desc,
            $blog_status,
            $save
        ));
    }
}
