<?php

class Application_Form_Category extends Zend_Form
{

    public function init()
    {
        /* Form Elements & Other Definitions Here ... */
        $token = new Zend_Form_Element_Hash("token");
        $token->setTimeout(Application_Model_Cache_Config::getConfig("FORM_CSRF_TOKEN_EXPIRE"));
        
        $category_title = new Zend_Form_Element_Text("category_title");
        $category_title->setLabel("Category")->setRequired(true);
        
        $category_icon = new Zend_Form_Element_Text("category_icon");
        $category_icon->setLabel("Icon")->setRequired(true);
        
        $category_desc = new Zend_Form_Element_Textarea("category_desc");
        $category_desc->setLabel("Description")->setRequired(true)->setAttrib('rows', 5);
        
        $category_meta_key = new Zend_Form_Element_Textarea("category_meta_key");
        $category_meta_key->setLabel("Meta Key")->setRequired(true)->setAttrib('rows', 5);
        
        $category_parent = new Zend_Form_Element_Select("category_parent");
        $category_parent->setLabel("Parent")->setRequired(true);
        $category_parent->addMultiOption('0', '-- Select Parent category --');
        $obj_cat = new Application_Model_CategoryLogic(-1);
        foreach($obj_cat->getParentCategory($this->getAttrib('type')) as $row) {
            $category_parent->addMultiOption($row->id, $row->category_title);
        }
        
        $category_type = new Zend_Form_Element_Select('category_type');
        $category_type->setLabel("Type")->setRequired(true)->setDescription("Blog type will not display on Category");
        $category_type->addMultiOptions(Application_Model_CategoryLogic::$categoryType);
        
        $category_image = new Zend_Form_Element_File("category_image");
        $category_image->setLabel("Feature Image")->setRequired(true);
        $filename = date('d_M_y_H_i_s') . '_category_' . ((null != $category_image->getFileName(null, false)) ? $category_image->getFileName(null, false) : '');
        $category_image->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME') . '/' . Application_Model_Cache_Config::getConfig('CATEGORY_FOLDER') . '/')
            ->addFilter('Rename', $filename)
            ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE_LIBRARY'))
            ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS'))
            ->setDescription('Only ' . Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS') . ' files allowed');
        
        $category_status = new Zend_Form_Element_Radio("category_status");
        $category_status->setLabel("Status")->setRequired(true);
        $category_status->addMultiOptions(Application_Model_Cache_Config::getConfig('STATUS_TYPE'));
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-blue4');
        
        $this->addElements(array($token,
        $category_title,
        $category_icon,
        $category_desc,
        $category_meta_key,
        $category_parent,
        $category_type,
        $category_image,
        $category_status,
        $save));
    }


}

