<?php

class Application_Form_Circular extends Zend_Form
{

    /**
     * Method initialize form fields of asit_circulars table
     *
     * @var varchar circular_title
     * @var varchar circular_intro_text
     * @var text circular_desc
     * @var datetime circular_start
     * @var datetime circular_end
     * @var varchar circular_url
     * @var varchar circular_color
     * @var int circular_site
     * @var varchar circular_status
     * @var int circular_updated_by
     * @var timestamp circular_updated_date
     * @var int circular_created_by
     * @var timestamp circular_created_date
     */
    public function init()
    {
        
        $token = new Zend_Form_Element_Hash("token");
        
        $circular_title = new Zend_Form_Element_Text("circular_title");
        $circular_title->setLabel("Activity")->setRequired(true)->setAttrib('onchange', 'updateUrl(this.value);');
        
        $circular_desc = new Zend_Form_Element_Textarea("circular_desc");
        $circular_desc->setLabel("Description")->setRequired(true)->setAttrib('rows', 5);
        
        $circular_file = new Zend_Form_Element_File("circular_file");
        $circular_file->setLabel("File")->setRequired(true);
        $filename = date('d_M_y_H_i_s') . '_lib_' .((null != $circular_file->getFileName(null, false)) ? $circular_file->getFileName(null, false) : '');
        $circular_file->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME').'/circular/') 
            ->addFilter('Rename', $filename)
            ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE_LIBRARY'))
            ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_ALLOW_EXTENSIONS'))
            ->setDescription('Only '.Application_Model_Cache_Config::getConfig('UPLOAD_ALLOW_EXTENSIONS').' files allowed');
        
        $circular_status = new Zend_Form_Element_Radio("circular_status");
        $circular_status->setLabel("Status")->setRequired(true);
        $circular_status->addMultiOptions(Application_Model_Cache_Config::getConfig('STATUS_TYPE'));
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-blue4');
        
        $this->addElements(array($token,
        $circular_title,
        $circular_desc,
        $circular_file,
        $circular_status,
        $save));
    }


}
