<?php
class Application_Form_City extends Zend_Form
{
    
    public function init()
    {
        
        $token = new Zend_Form_Element_Hash("token");
        $token->setTimeout(Application_Model_Cache_Config::getConfig("FORM_CSRF_TOKEN_EXPIRE"));
        
        $city_name = new Zend_Form_Element_Text("city_name");
        $city_name->setLabel("Name")->setRequired(true)->setAttrib('class', 'form-control');
        
        $city_desc = new Zend_Form_Element_Textarea("city_desc");
        $city_desc->setLabel("Description")->setAttrib('rows', 5);
        
        $city_image = new Zend_Form_Element_File("city_image");
        $city_image->setLabel("Image");
        $filename = date('d_M_y_H_i_s') . '_city_' . ((null != $city_image->getFileName(null, false)) ? $city_image->getFileName(null, false) : '');
        $city_image->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME') . '/' . Application_Model_Cache_Config::getConfig('CITY_FOLDER') . '/')
        ->addFilter('Rename', $filename)->setAttrib('style', 'float: left;')
        ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE_LIBRARY'))
        ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS'))
        ->setDescription('Only ' . Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS') . ' files allowed')
        ->removeDecorator('DtDdWrapper')->removeDecorator('HtmlTag')->removeDecorator('Label');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib("class", "btn btn-blue4");
        
        $this->addElements(array($token,
            $city_name,
            $city_desc,
            $city_image,
            $save));
    }
    
    
}