<?php
/**
 * Zend Form implementing a form to process the data.
 *
 * Cloud canny config Data Process via this form.
 *
 * @package Sakshi Infotech Code
 * @name Cloud canny config Form
 * @filesource application/model
 * @author Akhil Gupta
 * @copyright Sakshi Infotech
 * @version 1.0
 * @license Sakshi Infotech
 * @subpackage Zend_Forms
 */
class Application_Form_Config extends Zend_Form
{

    /**
     * Method initialize form fields of cloud_canny_config table
     *
     * @var varchar config_key
     * @var text config_value
     * @var tinyint config_serialize
     * @var int config_updated_by
     * @var timestamp config_updated_date
     * @var int config_created_by
     * @var datetime config_created_date
     */
    public function init()
    {
        $token = new Zend_Form_Element_Hash("token");
        $token->setTimeout(Application_Model_Cache_Config::getConfig("FORM_CSRF_TOKEN_EXPIRE"));
        
        $config_key = new Zend_Form_Element_Text("config_key");
        $config_key->setLabel("Key")->setRequired(true)->setAttrib('class', 'form-control');
        
        $config_value = new Zend_Form_Element_Textarea("config_value");
        $config_value->setLabel("Value")->setRequired(true)->setAttrib('rows', 5)->setAttrib('class', 'form-control');
        
        $config_serialize = new Zend_Form_Element_Checkbox("config_serialize");
        $config_serialize->setLabel("Is Serialize?")->setRequired(true);
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-primary');
        
        $this->addElements(array($token,
        $config_key,
        $config_value,
        $config_serialize,
        $save));
    }


}
