<?php

class Application_Form_Download extends Zend_Form
{

    /**
     * Method initialize form fields of asit_downloads table
     *
     * @var varchar download_title
     * @var varchar download_intro_text
     * @var text download_desc
     * @var datetime download_start
     * @var datetime download_end
     * @var varchar download_url
     * @var varchar download_color
     * @var int download_site
     * @var varchar download_status
     * @var int download_updated_by
     * @var timestamp download_updated_date
     * @var int download_created_by
     * @var timestamp download_created_date
     */
    public function init()
    {
        
        $token = new Zend_Form_Element_Hash("token");
        
        $download_title = new Zend_Form_Element_Text("download_title");
        $download_title->setLabel("Activity")->setRequired(true)->setAttrib('onchange', 'updateUrl(this.value);');
        
        $download_desc = new Zend_Form_Element_Textarea("download_desc");
        $download_desc->setLabel("Description")->setRequired(true)->setAttrib('rows', 5);
        
        $download_file = new Zend_Form_Element_File("download_file");
        $download_file->setLabel("File")->setRequired(true);
        $filename = date('d_M_y_H_i_s') . '_lib_' .((null != $download_file->getFileName(null, false)) ? $download_file->getFileName(null, false) : '');
        $download_file->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME').'/download/') 
            ->addFilter('Rename', $filename)
            ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE_LIBRARY'))
            ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_ALLOW_EXTENSIONS'))
            ->setDescription('Only '.Application_Model_Cache_Config::getConfig('UPLOAD_ALLOW_EXTENSIONS').' files allowed');
        
        $download_status = new Zend_Form_Element_Radio("download_status");
        $download_status->setLabel("Status")->setRequired(true);
        $download_status->addMultiOptions(Application_Model_Cache_Config::getConfig('STATUS_TYPE'));
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-blue4');
        
        $this->addElements(array($token,
        $download_title,
        $download_desc,
        $download_file,
        $download_status,
        $save));
    }


}
