<?php

class Application_Form_EmailAttachment extends Zend_Form
{

    public function init()
    {
        $id = new Zend_Form_Element_Hidden("id");
        
        $email_attachment = new Zend_Form_Element_File("email_attachment");
        $email_attachment->setLabel("Upload");
        $filename = ($email_attachment->getFileName(null, false) != null) ? $email_attachment->getFileName(null, false) : '';
        $email_attachment->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME').'/email/') 
            ->addFilter('Rename', $filename)
            ->addValidator('Extension', false, 'jpg,png,gif,doc,pdf')
            ->setDescription('Only jpg,png,gif,doc,pdf files allowed');
        $email_attachment->removeDecorator('DtDdWrapper')->removeDecorator('HtmlTag')->removeDecorator('Label');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Upload")->setRequired(true)->removeDecorator('DtDdWrapper')->removeDecorator('HtmlTag')->setAttrib("class", "btn btn-blue4");
        
        $this->addElements(array($id,
        $email_attachment,
        $save));
    }


}


