<?php

class Application_Form_Events extends Zend_Form
{

    /**
     * Method initialize form fields of asit_events table
     *
     * @var varchar event_title
     * @var varchar event_intro_text
     * @var text event_desc
     * @var datetime event_start
     * @var datetime event_end
     * @var varchar event_url
     * @var varchar event_color
     * @var int event_site
     * @var varchar event_status
     * @var int event_updated_by
     * @var timestamp event_updated_date
     * @var int event_created_by
     * @var timestamp event_created_date
     */
    public function init()
    {
        
        echo '<script type="text/javascript">CKEDITOR.replace("event_desc");'
        . 'function updateUrl(val) { $("#event_url").val(val.toLowerCase().split(" ").join("-")); }</script>';
        
        $token = new Zend_Form_Element_Hash("token");
        
        $event_title = new Zend_Form_Element_Text("event_title");
        $event_title->setLabel("Event")->setRequired(true)->setAttrib('onchange', 'updateUrl(this.value);');
        
        $event_intro_text = new Zend_Form_Element_Textarea("event_intro_text");
        $event_intro_text->setLabel("Intro Text")->setRequired(true)->setAttrib('rows', 5);
        
        $event_desc = new Zend_Form_Element_Textarea("event_desc");
        $event_desc->setLabel("Description")->setRequired(true)->setAttrib('rows', 5);
        
        $event_start = new Zend_Form_Element_Text("event_start");
        $event_start->setLabel("Start")->setRequired(true)->setAttrib('class', 'datepick');
        
        $event_end = new Zend_Form_Element_Text("event_end");
        $event_end->setLabel("End")->setRequired(true)->setAttrib('class', 'datepick');
        
        $event_url = new Zend_Form_Element_Text("event_url");
        $event_url->setLabel("URL")->setRequired(true);
        
        $event_color = new Zend_Form_Element_Hidden("event_color");
        $event_color->setValue('blue');
        
        $event_status = new Zend_Form_Element_Radio("event_status");
        $event_status->setLabel("Status")->setRequired(true);
        $event_status->addMultiOptions(Application_Model_Cache_Config::getConfig('STATUS_TYPE'));
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-blue4');
        
        $this->addElements(array($token,
        $event_title,
        $event_intro_text,
        $event_desc,
        $event_start,
        $event_end,
        $event_url,
        $event_color,
        $event_status,
        $save));
    }


}
