<?php

class Application_Form_Image extends Zend_Form
{

    /**
     * Method initialize form fields of asit_album_image table
     *
     * @var varchar image_title
     * @var varchar image_desc
     * @var varchar image_path
     * @var int image_album
     * @var varchar image_status
     * @var int image_updated_by
     * @var timestamp image_updated_date
     * @var int image_created_by
     * @var timestamp image_created_date
     */
    public function init()
    {
        $token = new Zend_Form_Element_Hash("token");
        
        $image_title = new Zend_Form_Element_Text("image_title");
        $image_title->setLabel("Title")->setRequired(true);
        
        $image_desc = new Zend_Form_Element_Textarea("image_desc");
        $image_desc->setLabel("Description")->setRequired(true)->setAttrib('rows', 5);
        
        $image_path = new Zend_Form_Element_File("image_path");
        $image_path->setLabel("Image")->setRequired(true);
        $filename = date('d_M_y_H_i_s') .((null != $image_path->getFileName(null, false)) ? $image_path->getFileName(null, false) : '');
        $image_path->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME').'/image/') 
            ->addFilter('Rename', $filename)
            ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE'))
            ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS'))
            ->setDescription('Only '.Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS').' files allowed');
        
        $image_status = new Zend_Form_Element_Radio("image_status");
        $image_status->setLabel("Status")->setRequired(true);
        $image_status->addMultiOptions(Application_Model_Cache_Config::getConfig('STATUS_TYPE'));
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-blue4');
        
        $this->addElements(array($token,
        $image_title,
        $image_desc,
        $image_path,
        $image_status,
        $save));
    }


}
