<?php

class Application_Form_Library extends Zend_Form
{

    public function init()
    {
        /* Form Elements & Other Definitions Here ... */
        $token = new Zend_Form_Element_Hash("token");
        $token->setTimeout(Application_Model_Cache_Config::getConfig("FORM_CSRF_TOKEN_EXPIRE"));
        
        $baseUrl = new Zend_View_Helper_BaseUrl();
        
        echo "<script type='text/javascript'> function getCategory(id) { $.post('".$baseUrl->baseUrl('ajax/category-by-parent/id/')."'+id, function(data){ $('#library_category').html(data);  }); } </script>";
        
        $parent_cat = new Zend_Form_Element_Select('parent_cat');
        $parent_cat->setLabel('Parent Category')->setRequired(true)->setAttrib('onchange', 'getCategory(this.value)');
        $parent_cat->addMultiOption('', '-- Select Parent Category --');
        $obj_cat = new Application_Model_CategoryLogic(-1);
        foreach($obj_cat->getParentCategory('L') as $cat) {
            $parent_cat->addMultiOption($cat->id, $cat->category_title);
        }
        
        $library_category = new Zend_Form_Element_Select('library_category');
        $library_category->setLabel('Category')->setRequired(true);
        $library_category->setRegisterInArrayValidator(false);
        $library_category->addMultiOption("", "-- Select Category --");
        
        $library_title = new Zend_Form_Element_Text("library_title");
        $library_title->setLabel("Title")->setRequired(true);
        
        $library_desc = new Zend_Form_Element_Textarea("library_desc");
        $library_desc->setLabel("Description")->setRequired(true)->setAttrib('rows', '5');
        
        $library_file = new Zend_Form_Element_File("library_file");
        $library_file->setLabel("File")->setRequired(true);
        $filename = date('d_M_y_H_i_s') . '_lib_' .((null != $library_file->getFileName(null, false)) ? $library_file->getFileName(null, false) : '');
        $library_file->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME').'/'.Application_Model_Cache_Config::getConfig('LIBRARY_FOLDER').'/') 
            ->addFilter('Rename', $filename)
            ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE_LIBRARY'))
            ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_ALLOW_EXTENSIONS'))
            ->setDescription('Only '.Application_Model_Cache_Config::getConfig('UPLOAD_ALLOW_EXTENSIONS').' files allowed');
        
        $library_visibility = new Zend_Form_Element_Radio("library_visibility");
        $library_visibility->setLabel("Visibility")->setRequired(true)->setValue('Public');
        $library_visibility->addMultiOption('Public', 'Public');
        $library_visibility->addMultiOption('Private', 'Private');
        
        $library_status = new Zend_Form_Element_Radio("library_status");
        $library_status->setLabel("Status")->setRequired(true);
        $library_status->addMultiOptions(Application_Model_Cache_Config::getConfig('STATUS_TYPE'));
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Upload")->setRequired(true)->setAttrib('class', 'btn btn-primary');
        
        $this->addElements(array($token,$parent_cat, $library_category,
        $library_title,
        $library_desc,
        $library_file,
        $library_visibility,
        $library_status,
        $save));
    }


}

