<?php
/**
 * Zend Form implementing a form to process the data.
 *
 * Asit list Data Process via this form.
 *
 * @package Sakshi Infotech Code
 * @name Asit list Form
 * @filesource application/model
 * @author Akhil Gupta
 * @copyright Sakshi Infotech
 * @version 1.0
 * @license Sakshi Infotech
 * @subpackage Zend_Forms
 */
class Application_Form_List extends Zend_Form
{
    
    /**
     * Method initialize form fields of asit_list table
     *
     * @var varchar list_title
     * @var int list_category
     * @var varchar list_short_desc
     * @var text list_desc
     * @var varchar list_image
     * @var varchar list_tag_line
     * @var varchar list_address
     * @var varchar list_area
     * @var varchar list_phone
     * @var varchar list_email
     * @var varchar list_website
     * @var varchar list_social
     * @var float list_review_score
     * @var int list_review_total
     * @var tinyint list_is_claimed
     * @var varchar list_status
     * @var int list_updated_by
     * @var timestamp list_updated_date
     * @var int list_created_by
     * @var timestamp list_created_date
     */
    public function init()
    {
        $token = new Zend_Form_Element_Hash("token");
        $obj_base = new Zend_View_Helper_BaseUrl();
        
        echo "<script type='text/javascript'> CKEDITOR.replace( 'list_desc',{fullPage : true, width: 650, filebrowserBrowseUrl :'".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserImageBrowseUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Type=Image&Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserFlashBrowseUrl :'".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Type=Flash&Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserUploadUrl  :'".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=File')."',
                filebrowserImageUploadUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=Image')."',
                filebrowserFlashUploadUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=Flash')."'});</script>";
        
        
        $list_title = new Zend_Form_Element_Text("list_title");
        $list_title->setLabel("Restaurant Name")->setRequired(true);
        
        $list_category = new Zend_Form_Element_Select("list_category");
        $list_category->setLabel("Main Category")->setRequired(true);
        $obj_cat = new Application_Model_CategoryLogic(-1);
        $list_category->addMultiOption('', '-- Select Category --');
        foreach($obj_cat->getParentCategory() as $category) {
            $list_category->addMultiOption($category->id, $category->category_title);
        }
        
        $list_other_category = new Zend_Form_Element_Multiselect("list_other_category");
        $list_other_category->setLabel("Other Categories");
        foreach($obj_cat->getParentCategory() as $category) {
            $list_other_category->addMultiOption($category->id, $category->category_title);
        }
        
        $list_short_desc = new Zend_Form_Element_Textarea("list_short_desc");
        $list_short_desc->setLabel("Short Description")->setRequired(true)->setAttrib('rows', 5);
        
        $list_desc = new Zend_Form_Element_Textarea("list_desc");
        $list_desc->setLabel("Description")->setRequired(true);
        
        $list_image = new Zend_Form_Element_File("list_image");
        $list_image->setLabel("Image")->setRequired(true);
        $filename = date('d_M_y_H_i_s') . '_list_' . ((null != $list_image->getFileName(null, false)) ? $list_image->getFileName(null, false) : '');
        $list_image->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME') . '/' . Application_Model_Cache_Config::getConfig('LIST_FOLDER') . '/')
        ->addFilter('Rename', $filename)
        ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE_LIBRARY'))
        ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS'))
        ->setDescription('Only ' . Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS') . ' files allowed');
        
        $list_tag_line = new Zend_Form_Element_Text("list_tag_line");
        $list_tag_line->setLabel("Tag Line")->setRequired(true);
        
        $list_address = new Zend_Form_Element_Textarea("list_address");
        $list_address->setLabel("Address")->setRequired(true)->setAttrib('rows', 5);
        
        $list_city = new Zend_Form_Element_Select("list_city");
        $list_city->setLabel("City")->setRequired(true);
        $list_city->addMultiOption('', '-- Select City --');
        $obj_city = new Application_Model_CityLogic(-1);
        foreach($obj_city->fetchOrdered() as $city) {
            $list_city->addMultiOption($city->id, $city->city_name);
        }
        
        $list_phone = new Zend_Form_Element_Text("list_phone");
        $list_phone->setLabel("Phone")->setRequired(true);
        
        $list_email = new Zend_Form_Element_Text("list_email");
        $list_email->setLabel("Email")->setRequired(true);
        
        $list_website = new Zend_Form_Element_Text("list_website");
        $list_website->setLabel("Website")->setRequired(true);
        
        $list_amenities = new Zend_Form_Element_MultiCheckbox('list_amenities');
        $list_amenities->setSeparator('')->setLabel('Amenities');
        foreach(Application_Model_ListMetaLogic::$amenities as $key=>$val) {
            $list_amenities->addMultiOption($key, $val['title']);
        }
        
        $list_target = new Zend_Form_Element_MultiCheckbox('list_target');
        $list_target->setSeparator('')->setLabel('Target Audience');
        foreach(Application_Model_ListMetaLogic::$target as $key=>$val) {
            $list_target->addMultiOption($key, $val['title']);
        }
        
        $list_tags = new Zend_Form_Element_Textarea("list_tags");
        $list_tags->setLabel("Tags")->setAttrib('rows', 5)->setDescription("Please enter comma seprated value.");
        
        $list_fb = new Zend_Form_Element_Text('list_fb');
        $list_fb->setLabel('Facebook URL'); 
        
        $list_tweet = new Zend_Form_Element_Text('list_tweet');
        $list_tweet->setLabel('Twitter URL'); 
        
        $list_insta = new Zend_Form_Element_Text('list_insta');
        $list_insta->setLabel('Instagram Page URL');
        
        $list_rate_ambience = new Zend_Form_Element_Radio('list_rate_ambience');
        $list_rate_ambience->setRequired(true)->setLabel("Ambience")->addMultiOptions(array("1"=>"1", "2"=>"2", "3"=>"3", "4"=>"4", "5"=>"5"))->setSeparator('');
        
        $list_rate_food = new Zend_Form_Element_Radio('list_rate_food');
        $list_rate_food->setRequired(true)->setLabel("Food")->addMultiOptions(array("1"=>"1", "2"=>"2", "3"=>"3", "4"=>"4", "5"=>"5"))->setSeparator('');
        
        $list_rate_service = new Zend_Form_Element_Radio('list_rate_service');
        $list_rate_service->setRequired(true)->setLabel("Services")->addMultiOptions(array("1"=>"1", "2"=>"2", "3"=>"3", "4"=>"4", "5"=>"5"))->setSeparator('');
        
        $list_rate_value = new Zend_Form_Element_Radio('list_rate_value');
        $list_rate_value->setRequired(true)->setLabel("Value For Money")->addMultiOptions(array("1"=>"1", "2"=>"2", "3"=>"3", "4"=>"4", "5"=>"5"))->setSeparator('');
        
        $list_type = new Zend_Form_Element_Select('list_type');
        $list_type->setLabel('Listing Type')->setRequired(true);
        $list_type->addMultiOptions(Application_Model_ListLogic::$listType);
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-blue4');
        
        $this->addElements(array($token,
            $list_title,
            $list_category,
            $list_other_category,
            $list_short_desc,
            $list_desc,
            $list_image,
            $list_tag_line,
            $list_address,
            $list_city,
            $list_phone,
            $list_email,
            $list_website,
            $list_amenities,
            $list_target,
            $list_tags,
            $list_fb,
            $list_tweet,
            $list_insta,
            $list_rate_ambience,
            $list_rate_service,
            $list_rate_food,
            $list_rate_value,
            $list_type,
            $save));
    }
    
    
}
