<?php
class Application_Form_ListImage extends Zend_Form
{
    
    public function init()
    {
        $list_id = new Zend_Form_Element_Hidden("list_id");
        $list_id->setRequired(true)->removeDecorator('DtDdWrapper')->removeDecorator('HtmlTag')->removeDecorator('Label');
        
        $list_image_path = new Zend_Form_Element_File("list_image_path");
        $list_image_path->setLabel("Image");
        $filename = date('d_M_y_H_i_s') . '_list_' . ((null != $list_image_path->getFileName(null, false)) ? $list_image_path->getFileName(null, false) : '');
        $list_image_path->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME') . '/' . Application_Model_Cache_Config::getConfig('LIST_FOLDER') . '/')
        ->addFilter('Rename', $filename)->setAttrib('style', 'float: left;')
        ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE_LIBRARY'))
        ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS'))
        ->setDescription('Only ' . Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS') . ' files allowed')
        ->removeDecorator('DtDdWrapper')->removeDecorator('HtmlTag')->removeDecorator('Label');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Upload")->setRequired(true)->setAttrib("style", "float: left;   margin-left: 205px; margin-top: -25px;")->removeDecorator('DtDdWrapper')->removeDecorator('HtmlTag')->removeDecorator('Label');
        
        $this->addElements(array($list_id,
            $list_image_path,
            $save));
    }
    
    
}