<?php

class Application_Form_Menu extends Zend_Form
{

    public function init()
    {
        
        $baseUrl = new Zend_View_Helper_BaseUrl();
        echo '<script type="text/javascript"> function getContent(x){ $.post("'.$baseUrl->baseUrl().'/dynasty/menu/content/type/"+x, function(data){ $("#menu_content").html(data); }); }</script>';
        echo '<script type="text/javascript"> function getUri(x){ $.post("'.$baseUrl->baseUrl().'/dynasty/menu/url/type/"+$("#menu_type").val()+"/id/"+x, function(data){ if(x == "U") { $("#menu_url").val(""); $("#menu_url").removeAttr("readonly");  }else {  $("#menu_url").val(data); $("#menu_url").attr("readonly", true); } }); }</script>';
        
        /* Form Elements & Other Definitions Here ... */
        $token = new Zend_Form_Element_Hash("token");
        $token->setTimeout(Application_Model_Cache_Config::getConfig("FORM_CSRF_TOKEN_EXPIRE"));
        
        $menu_title = new Zend_Form_Element_Text("menu_title");
        $menu_title->setLabel("Menu")->setRequired(true)->setAttrib('class', 'form-control');
        
        $menu_desc = new Zend_Form_Element_Textarea("menu_desc");
        $menu_desc->setLabel("Description")->setAttrib('rows', 5)->setRequired(true)->setAttrib('class', 'form-control');
        
        $menu_type = new Zend_Form_Element_Select('menu_type');
        $menu_type->setLabel("Type")->setRequired(true)->setAttrib('onchange', 'getContent(this.value)');
        $menu_type->addMultiOption('', '-- Select Type --');
        $menu_type->addMultiOptions(array('P'=>'Page', 'H'=>'Home', 'G'=>'Gallery', 'U'=>'URL', 'N'=>'News', 'C'=>'Circulars', 'D'=>'Download', 'E'=>'Yearly Calendar', 'EU'=>'Upcoming Events', 'CU'=>'Contact Us'));
        
        $menu_content = new Zend_Form_Element_Select('menu_content');
        $menu_content->setLabel("Content")->setAttrib('onchange', 'getUri(this.value);');
        $menu_content->setRegisterInArrayValidator(false);
        $menu_content->addMultiOption('', '-- Select Content --');
        
        $menu_url = new Zend_Form_Element_Text("menu_url");
        $menu_url->setLabel("URL")->setRequired(true);
        
        $menu_parent = new Zend_Form_Element_Select('menu_parent');
        $menu_parent->setLabel('Parent Menu');
        $menu_parent->addMultiOption('0', '-- Parent Menu --');
        $obj_menu = new Application_Model_MenuLogic(-1);
        foreach($obj_menu->getAllParentMenu() as $menu) {
            $menu_parent->addMultiOption($menu->id, $menu->menu_title);
        }
        
        $menu_order = new Zend_Form_Element_Select('menu_order');
        $menu_order->setLabel('Menu Order')->setRequired(true);
        for($i = 1; $i<=20; $i++) {
            $menu_order->addMultiOption($i, $i);
        }
        
        $menu_status = new Zend_Form_Element_Radio("menu_status");
        $menu_status->setLabel("Status")->setRequired(true)->setSeparator(' ');
        $menu_status->addMultiOption('A', 'Active');
        $menu_status->addMultiOption('B', 'Block');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-primary');
        
        $this->addElements(array($token,
        $menu_title,
        $menu_desc,
        $menu_type,
        $menu_content,
        $menu_url,
        $menu_parent,
        $menu_order,
        $menu_status,
        $save));
    }


}

