<?php
/**
 * Zend Form implementing a form to process the data.
 *
 * Cloud canny config Data Process via this form.
 *
 * @package Sakshi Infotech Code
 * @name Cloud canny config Form
 * @filesource application/model
 * @author Akhil Gupta
 * @copyright Sakshi Infotech
 * @version 1.0
 * @license Sakshi Infotech
 * @subpackage Zend_Forms
 */
class Application_Form_Message extends Zend_Form
{

    /**
     * Method initialize form fields of cloud_canny_config table
     *
     * @var varchar config_key
     * @var text config_value
     * @var tinyint config_serialize
     * @var int config_updated_by
     * @var timestamp config_updated_date
     * @var int config_created_by
     * @var datetime config_created_date
     */
    public function init()
    {
        $obj_base = new Zend_View_Helper_BaseUrl();
        
        echo "<script type='text/javascript'> function draftSave(x) { $('#message_action').val(x); return true; }; "
                . "CKEDITOR.replace( 'message_content',{fullPage : true,width: 650,filebrowserBrowseUrl :'".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserImageBrowseUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Type=Image&Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserFlashBrowseUrl :'".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Type=Flash&Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserUploadUrl  :'".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=File')."',
                filebrowserImageUploadUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=Image')."',
                filebrowserFlashUploadUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=Flash')."',removePlugins : 'strinsert'});</script>";
        
        $token = new Zend_Form_Element_Hash("token");
        $token->setTimeout(Application_Model_Cache_Config::getConfig("FORM_CSRF_TOKEN_EXPIRE"));
        
        $message_action = new Zend_Form_Element_Hidden('message_action');
        
        $message_to = new Zend_Form_Element_Select("message_to");
        $message_to->setLabel("To")->setRequired(true)->setAttrib('class', 'cho chzn-done');
        $obj_user = new Application_Model_UserLogic(-1);
        $message_to->addMultiOption(-1, '-- Select User --');
        foreach($obj_user->fetchActiveUsers() as $user) {
            $message_to->addMultiOption($user->id, $user->user_name);
        }
        
        $message_subject = new Zend_Form_Element_Text("message_subject");
        $message_subject->setLabel("Subject")->setRequired(true);
        
        $message_content = new Zend_Form_Element_Textarea("message_content");
        $message_content->setLabel("Message")->setRequired(true)->setAttrib('rows', 5);
        
        $draft = new Zend_Form_Element_Submit("draft");
        $draft->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-info')->setAttrib('onclick', 'return draftSave("Draft");');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Send")->setRequired(true)->setAttrib('onclick', 'return draftSave("Send");')->setAttrib('class', 'btn btn-primary')->removeDecorator('HtmlTag')->removeDecorator('Label');
        
        
        $this->addElements(array($message_action,
        $message_to,
        $message_subject,
        $message_content, $draft,
        $save));
    }


}
