<?php

/**
 * Zend Form implementing a form to process the data.
 *
 * Asit news Data Process via this form.
 *
 * @package Sakshi Infotech Code
 * @name Asit news Form
 * @filesource application/model
 * @author Akhil Gupta
 * @copyright Sakshi Infotech
 * @version 1.0
 * @license Sakshi Infotech
 * @subpackage Zend_Forms
 */
class Application_Form_News extends Zend_Form
{
    
    /**
     * Method initialize form fields of asit_news table
     *
     * @var varchar news_title
     * @var varchar news_image
     * @var varchar news_short_desc
     * @var text news_desc
     * @var varchar news_url
     * @var varchar news_meta_key
     * @var varchar news_meta_desc
     * @var varchar news_status
     * @var int news_updated_by
     * @var timestamp news_updated_date
     * @var int news_created_by
     * @var timestamp news_created_date
     */
    public function init()
    {
        $token = new Zend_Form_Element_Hash("token");
        $obj_base = new Zend_View_Helper_BaseUrl();
        
        echo "<script type='text/javascript'> CKEDITOR.replace( 'news_desc',{fullPage : true,width: 650,filebrowserBrowseUrl :'".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserImageBrowseUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Type=Image&Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserFlashBrowseUrl :'".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Type=Flash&Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserUploadUrl  :'".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=File')."',
                filebrowserImageUploadUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=Image')."',
                filebrowserFlashUploadUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=Flash')."'});</script>";
        
        
        $news_title = new Zend_Form_Element_Text("news_title");
        $news_title->setLabel("Title")->setRequired(true);
        
        $news_image = new Zend_Form_Element_File("news_image");
        $news_image->setLabel("Feature Image");
        $filename = date('d_M_y_H_i_s') . '_news_' . ((null != $news_image->getFileName(null, false)) ? $news_image->getFileName(null, false) : '');
        $news_image->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME') . '/' . Application_Model_Cache_Config::getConfig('NEWS_FOLDER') . '/')
        ->addFilter('Rename', $filename)
        ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE_LIBRARY'))
        ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS'))
        ->setDescription('Only ' . Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS') . ' files allowed');
        
        $news_short_desc = new Zend_Form_Element_Textarea("news_short_desc");
        $news_short_desc->setLabel("Short Description")
        ->setAttrib('rows', 5);
        
        $news_desc = new Zend_Form_Element_Textarea("news_desc");
        $news_desc->setLabel("Description")->setRequired(true);
        
        $news_meta_key = new Zend_Form_Element_Textarea("news_meta_key");
        $news_meta_key->setLabel("Meta Key")
        ->setAttrib('rows', 5);
        
        $news_meta_desc = new Zend_Form_Element_Textarea("news_meta_desc");
        $news_meta_desc->setLabel("Meta Description")
        ->setAttrib('rows', 5);
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")
        ->setRequired(true)
        ->setAttrib('class', 'btn btn-blue4');
        
        $this->addElements(array(
            $token,
            $news_title,
            $news_image,
            $news_short_desc,
            $news_desc,
            $news_meta_key,
            $news_meta_desc,
            $save
        ));
    }
}
