<?php

/**
 * Zend Form implementing a form to process the data.
 *
 * Asit page Data Process via this form.
 *
 * @package Sakshi Infotech Code
 * @name Asit page Form
 * @filesource application/model
 * @author Akhil Gupta
 * @copyright Sakshi Infotech
 * @version 1.0
 * @license Sakshi Infotech
 * @subpackage Zend_Forms
 */
class Application_Form_Page extends Zend_Form
{
    
    /**
     * Method initialize form fields of asit_page table
     *
     * @var varchar page_title
     * @var varchar page_image
     * @var varchar page_short_desc
     * @var text page_desc
     * @var varchar page_url
     * @var varchar page_meta_key
     * @var varchar page_meta_desc
     * @var varchar page_status
     * @var int page_updated_by
     * @var timestamp page_updated_date
     * @var int page_created_by
     * @var timestamp page_created_date
     */
    public function init()
    {
        $token = new Zend_Form_Element_Hash("token");
        $obj_base = new Zend_View_Helper_BaseUrl();
        
        echo "<script type='text/javascript'> CKEDITOR.replace( 'page_desc',{fullPage : true,width: 650,filebrowserBrowseUrl :'".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserImageBrowseUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Type=Image&Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserFlashBrowseUrl :'".$obj_base->baseUrl('js/ckeditor/filemanager/browser/default/browser.html')."?Type=Flash&Connector=".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/connector.php')."',
                filebrowserUploadUrl  :'".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=File')."',
                filebrowserImageUploadUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=Image')."',
                filebrowserFlashUploadUrl : '".$obj_base->baseUrl('js/ckeditor/filemanager/connectors/php/upload.php?Type=Flash')."'});</script>";
        
        
        $page_title = new Zend_Form_Element_Text("page_title");
        $page_title->setLabel("Title")->setRequired(true);
        
        $page_image = new Zend_Form_Element_File("page_image");
        $page_image->setLabel("Feature Image");
        $filename = date('d_M_y_H_i_s') . '_page_' . ((null != $page_image->getFileName(null, false)) ? $page_image->getFileName(null, false) : '');
        $page_image->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME') . '/' . Application_Model_Cache_Config::getConfig('PAGE_FOLDER') . '/')
        ->addFilter('Rename', $filename)
        ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE_LIBRARY'))
        ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS'))
        ->setDescription('Only ' . Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS') . ' files allowed');
        
        $page_short_desc = new Zend_Form_Element_Textarea("page_short_desc");
        $page_short_desc->setLabel("Short Description")
        ->setRequired(true)
        ->setAttrib('rows', 5);
        
        $page_desc = new Zend_Form_Element_Textarea("page_desc");
        $page_desc->setLabel("Description")->setRequired(true);
        
        $page_meta_key = new Zend_Form_Element_Textarea("page_meta_key");
        $page_meta_key->setLabel("Meta Key")
        ->setRequired(true)
        ->setAttrib('rows', 5);
        
        $page_meta_desc = new Zend_Form_Element_Textarea("page_meta_desc");
        $page_meta_desc->setLabel("Meta Description")
        ->setRequired(true)
        ->setAttrib('rows', 5);
        
        $page_status = new Zend_Form_Element_Radio("page_status");
        $page_status->setLabel("Status")
        ->setRequired(true)
        ->setSeparator(' ');
        $page_status->addMultiOption('A', 'Publish');
        $page_status->addMultiOption('E', 'Draft');
        $page_status->addMultiOption('B', 'Block');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")
        ->setRequired(true)
        ->setAttrib('class', 'btn btn-blue4');
        
        $this->addElements(array(
      //      $token,
            $page_title,
            //$page_image,
            $page_short_desc,
            $page_desc,
            $page_meta_key,
            $page_meta_desc,
            $page_status,
            $save
        ));
    }
}
