<?php
/**
 * Zend Form implementing a form to process the data.
 *
 * Asit list review Data Process via this form.
 *
 * @package Sakshi Infotech Code
 * @name Asit list review Form
 * @filesource application/model
 * @author Akhil Gupta
 * @copyright Sakshi Infotech
 * @version 1.0
 * @license Sakshi Infotech
 * @subpackage Zend_Forms
 */
class Application_Form_Review extends Zend_Form
{

    /**
     * Method initialize form fields of asit_list_review table
     *
     * @var int review_list
     * @var int review_user
     * @var tinyint review_score
     * @var varchar review_subject
     * @var text review_body
     * @var varchar review_status
     * @var int review_updated_by
     * @var timestamp review_updated_date
     * @var int review_created_by
     * @var timestamp review_created_date
     */
    public function init()
    {
        $token = new Zend_Form_Element_Hash("token");
        
        $review_list = new Zend_Form_Element_Hidden("review_list");
        
        $review_score = new Zend_Form_Element_Select("review_score");
        $review_score->setLabel("Score")->setRequired(true);
        $review_score->addMultiOptions(array("1"=>"1","2"=>"2","3"=>"3","4"=>"4","5"=>"5"));
        
        $review_subject = new Zend_Form_Element_Text("review_subject");
        $review_subject->setLabel("Subject")->setRequired(true);
        
        $review_body = new Zend_Form_Element_Textarea("review_body");
        $review_body->setLabel("Review")->setRequired(true)->setAttrib('rows', 5);
        
        $review_status = new Zend_Form_Element_Radio("review_status");
        $review_status->setLabel("Status")->setRequired(true);
        $review_status->addMultiOption('A', 'Active');
        $review_status->addMultiOption('S', 'Submitted');
        $review_status->addMultiOption('B', 'Block');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-blue4');
        
        $this->addElements(array($token,
        $review_list,
        $review_score,
        $review_subject,
        $review_body,
        $review_status,
        $save));
    }


}
