<?php

class Application_Form_Role extends Zend_Form
{

    public function init()
    {
        /* Form Elements & Other Definitions Here ... */
        $token = new Zend_Form_Element_Hash("token");
        $token->setTimeout(Application_Model_Cache_Config::getConfig("FORM_CSRF_TOKEN_EXPIRE"));
        
        $role_title = new Zend_Form_Element_Text("role_title");
        $role_title->setLabel("Role")->setRequired(true)->setAttrib('class', 'form-control');
        
        $role_description = new Zend_Form_Element_Textarea("role_description");
        $role_description->setLabel("Description")->setAttrib('rows', 5)->setRequired(true)->setAttrib('class', 'form-control');
        
        $permissions = new Zend_Form_Element_MultiCheckbox('permissions');
        $permissions->setLabel("Permissions")->setDescription('Please provide Permission to this role user.');
        $obj_per = new Application_Model_PermissionLogic(-1);
        foreach($obj_per->fetchOrdered() as $permission) {
            $permissions->addMultiOption($permission->id, $permission->permission_title);
        }
        $permissions->setSeparator('');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-primary');
        
        $this->addElements(array($token,
        $role_title,
        $role_description,
        $permissions,
        $save));
    }


}

