<?php

class Application_Form_Slider extends Zend_Form
{

    public function init()
    {
        /* Form Elements & Other Definitions Here ... */
        $token = new Zend_Form_Element_Hash("token");
        $token->setTimeout(Application_Model_Cache_Config::getConfig("FORM_CSRF_TOKEN_EXPIRE"));
        
        $slider_title = new Zend_Form_Element_Text("slider_title");
        $slider_title->setLabel("Title")->setRequired(true);
        
        $slider_image = new Zend_Form_Element_File("slider_image");
        $slider_image->setLabel("Image")->setRequired(true);
        $filename = date('d_M_y_H_i_s') . '_slider_' . ((null != $slider_image->getFileName(null, false)) ? $slider_image->getFileName(null, false) : '');
        $slider_image->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME') . '/' . Application_Model_Cache_Config::getConfig('SLIDER_FOLDER') . '/')
        ->addFilter('Rename', $filename)
        ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE'))
        ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS'))
        ->setDescription('Only ' . Application_Model_Cache_Config::getConfig('UPLOAD_IMAGE_EXTENSIONS') . ' files allowed');
        
        $slider_status = new Zend_Form_Element_Radio("slider_status");
        $slider_status->setLabel("Status")->setRequired(true)->setSeparator(' ');
        $slider_status->addMultiOption('A', 'Active');
        $slider_status->addMultiOption('B', 'Block');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-primary');
        
        $this->addElements(array($token,
        $slider_title,
        $slider_image,
        $slider_status,
        $save));
    }


}

