<?php
/**
 * Zend Form implementing a form to process the data.
 *
 * Cloud canny config Data Process via this form.
 *
 * @package Sakshi Infotech Code
 * @name Cloud canny config Form
 * @filesource application/model
 * @author Akhil Gupta
 * @copyright Sakshi Infotech
 * @version 1.0
 * @license Sakshi Infotech
 * @subpackage Zend_Forms
 */
class Application_Form_Tc extends Zend_Form
{

    /**
     * Method initialize form fields of asit_intro_tags table
     *
     * @var varchar tag_title
     * @var varchar tag_status
     * @var int tag_updated_by
     * @var timestamp tag_updated_date
     * @var int tag_created_by
     * @var timestamp tag_created_date
     */
    public function init()
    {
        $token = new Zend_Form_Element_Hash("token");
        
        $tc_student = new Zend_Form_Element_Text("tc_student");
        $tc_student->setLabel("Admission No.")->setRequired(true);
        
        $tc_file = new Zend_Form_Element_File("tc_file");
        $tc_file->setLabel("File")->setRequired(true);
        $filename = date('d_M_y_H_i_s') . '_tc_' . ((null != $tc_file->getFileName(null, false)) ? $tc_file->getFileName(null, false) : '');
        $tc_file->setDestination(Application_Model_Cache_Config::getConfig('UPLOAD_FOLDER_NAME') . '/' . Application_Model_Cache_Config::getConfig('TC_FOLDER') . '/')
        ->addFilter('Rename', $filename)
        ->addValidator('Size', false, Application_Model_Cache_Config::getConfig('MAXIMUM_UPLOAD_SIZE_LIBRARY'))
        ->addValidator('Extension', false, Application_Model_Cache_Config::getConfig('UPLOAD_ALLOW_EXTENSIONS'))
        ->setDescription('Only jpg, pdf, gif, png, doc files allowed');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setAttrib('class', 'btn btn-blue4')->setRequired(true);
        
        $this->addElements(array($token,
        $tc_student,
        $tc_file,
        $save));
    }


}
