<?php

class Application_Form_Todo extends Zend_Form
{

    public function init()
    {
        /* Form Elements & Other Definitions Here ... */
        $token = new Zend_Form_Element_Hash("token");
        $token->setTimeout(Application_Model_Cache_Config::getConfig("FORM_CSRF_TOKEN_EXPIRE"));
        
        $todo_title = new Zend_Form_Element_Text("todo_title");
        $todo_title->setLabel("Title")->setRequired(true);
        
        $todo_description = new Zend_Form_Element_Textarea("todo_description");
        $todo_description->setLabel("Description")->setRequired(true)->setAttrib('rows', '5');
        
        $todo_from_date = new Zend_Form_Element_Text("todo_from_date");
        $todo_from_date->setLabel("From Date")->setRequired(true)->setAttrib('class', 'datepick');
        
        $todo_to_date = new Zend_Form_Element_Text("todo_to_date");
        $todo_to_date->setLabel("To Date")->setRequired(true)->setAttrib('class', 'datepick');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-primary');
        
        $this->addElements(array($token,
        $todo_title,
        $todo_description,
        $todo_from_date,
        $todo_to_date,
        $save));
    }


}

