<?php
/**
 * Zend Form implementing a form to process the data.
 *
 * Cloud canny config Data Process via this form.
 *
 * @package Sakshi Infotech Code
 * @name Cloud canny config Form
 * @filesource application/model
 * @author Akhil Gupta
 * @copyright Sakshi Infotech
 * @version 1.0
 * @license Sakshi Infotech
 * @subpackage Zend_Forms
 */
class Application_Form_Topper extends Zend_Form
{

    /**
     * Method initialize form fields of asit_intro_tags table
     *
     * @var varchar tag_title
     * @var varchar tag_status
     * @var int tag_updated_by
     * @var timestamp tag_updated_date
     * @var int tag_created_by
     * @var timestamp tag_created_date
     */
    public function init()
    {
        $token = new Zend_Form_Element_Hash("token");
        
        $topper_name = new Zend_Form_Element_Text("topper_name");
        $topper_name->setLabel("Name")->setRequired(true);
        
        $topper_class = new Zend_Form_Element_Text("topper_class");
        $topper_class->setLabel("Class")->setRequired(true);
        
        $topper_percent = new Zend_Form_Element_Text("topper_percent");
        $topper_percent->setLabel("Percentage")->setRequired(true);
        $topper_percent->setDescription('Please do not put % sign.');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setAttrib('class', 'btn btn-blue4')->setRequired(true);
        
        $this->addElements(array($token,
        $topper_name,
        $topper_class,
        $topper_percent,
        $save));
    }


}
