<?php

class Application_Form_User extends Zend_Form
{

    public function init()
    {
        /* Form Elements & Other Definitions Here ... */
        $token = new Zend_Form_Element_Hash("token");
        $token->setTimeout(Application_Model_Cache_Config::getConfig("FORM_CSRF_TOKEN_EXPIRE"));
        
        $user_id = new Zend_Form_Element_Text("user_id");
        $user_id->setLabel("User Id")->setRequired(true);
        
        $user_password = new Zend_Form_Element_Text("user_password");
        $user_password->setLabel("Password")->setRequired(true)->setDescription('Please enter password only if you want to change the password.');
        
        $user_name = new Zend_Form_Element_Text("user_name");
        $user_name->setLabel("Name")->setRequired(true);
        
        $user_email = new Zend_Form_Element_Text("user_email");
        $user_email->setLabel("Email")->setRequired(true);
        
        $user_mobile = new Zend_Form_Element_Text("user_mobile");
        $user_mobile->setLabel("Mobile")->setRequired(true);
        
        $user_dob = new Zend_Form_Element_Text("user_dob");
        $user_dob->setLabel("Dob")->setRequired(true)->setAttrib('class', 'datepick');
        
        $user_gender = new Zend_Form_Element_Radio("user_gender");
        $user_gender->setLabel("Gender")->setRequired(true)->setSeparator(' ');
        $user_gender->addMultiOption('M', 'Male');
        $user_gender->addMultiOption('F', 'Female');
        $user_gender->addMultiOption('O', 'Other');
        
        $user_role = new Zend_Form_Element_Select("user_role");
        $user_role->setLabel("Role")->setRequired(true);
        $user_role->addMultiOption('', '-- Select Role --');
        $obj_role = new Application_Model_RoleLogic(-1);
        foreach($obj_role->fetchAll() as $row) {
            $user_role->addMultiOption($row->id, $row->role_title);
        }
        
        $user_status = new Zend_Form_Element_Radio("user_status");
        $user_status->setLabel("Status")->setRequired(true)->setSeparator(' ');
        $user_status->addMultiOption('A', 'Active');
        $user_status->addMultiOption('B', 'Block');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("save")->setRequired(true)->setAttrib('class', 'btn btn-primary');
        
        $this->addElements(array($token,
        $user_id,
        $user_password,
        $user_name,
        $user_email,
        $user_mobile,
        $user_dob,
        $user_gender,
        $user_role,
        $user_status,
        $save));
    }


}

