<?php

class Application_Form_Video extends Zend_Form
{

    /**
     * Method initialize form fields of asit_album_video table
     *
     * @var varchar video_title
     * @var varchar video_desc
     * @var varchar video_code
     * @var int video_album
     * @var varchar video_status
     * @var int video_updated_by
     * @var timestamp video_updated_date
     * @var int video_created_by
     * @var timestamp video_created_date
     */
    public function init()
    {
        $token = new Zend_Form_Element_Hash("token");
        
        $video_title = new Zend_Form_Element_Text("video_title");
        $video_title->setLabel("Title")->setRequired(true);
        
        $video_desc = new Zend_Form_Element_Textarea("video_desc");
        $video_desc->setLabel("Description")->setRequired(true)->setAttrib('rows', 5);
        
        $video_code = new Zend_Form_Element_Text("video_code");
        $video_code->setLabel("Youtube ID")->setRequired(true)->setAttrib('rows', 5);
        
        $video_status = new Zend_Form_Element_Radio("video_status");
        $video_status->setLabel("Status")->setRequired(true);
        $video_status->addMultiOptions(Application_Model_Cache_Config::getConfig('STATUS_TYPE'));
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-blue4');
        
        $this->addElements(array($token,
        $video_title,
        $video_desc,
        $video_code,
        $video_status,
        $save));
    }


}
