<?php

class Application_Form_Work extends Zend_Form
{

    public function init()
    {
        /* Form Elements & Other Definitions Here ... */
        $token = new Zend_Form_Element_Hash("token");
        $token->setTimeout(Application_Model_Cache_Config::getConfig("FORM_CSRF_TOKEN_EXPIRE"));
        
        $work_type = new Zend_Form_Element_Select('work_type');
        $work_type->setLabel("Allocated to")->setRequired(true)->setAttrib('onchange', 'populateTo(this.value);');
        $work_type->addMultiOption('', '-- Select Type --');
        $work_type->addMultiOption('R', 'Role');
        $work_type->addMultiOption('U', 'User');
        
        $work_to = new Zend_Form_Element_Select('work_to');
        $work_to->setRegisterInArrayValidator(false)->setRequired(true);
        $work_to->addMultiOption('', '-- Select --');
        
        $work_title = new Zend_Form_Element_Text("work_title");
        $work_title->setLabel("Title")->setRequired(true);
        
        $work_description = new Zend_Form_Element_Textarea("work_description");
        $work_description->setLabel("Description")->setRequired(true)->setAttrib('rows', '5');
        
        $work_from_date = new Zend_Form_Element_Text("work_from_date");
        $work_from_date->setLabel("From Date")->setRequired(true)->setAttrib('class', 'datepick');
        
        $work_to_date = new Zend_Form_Element_Text("work_to_date");
        $work_to_date->setLabel("To Date")->setRequired(true)->setAttrib('class', 'datepick');
        
        $work_priority = new Zend_Form_Element_Select('work_priority');
        $work_priority->setRequired(true)->setLabel('Priority');
        $work_priority->addMultiOption('L', 'Low');
        $work_priority->addMultiOption('M', 'Medium');
        $work_priority->addMultiOption('H', 'High');
        $work_priority->addMultiOption('U', 'Urgent');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-primary');
        
        $this->addElements(array($token, $work_type, $work_to,
        $work_title,
        $work_description,
        $work_from_date,
        $work_to_date,
        $work_priority,
        $save));
    }


}

