<?php

class Application_Form_WorkStatus extends Zend_Form
{

    public function init()
    {
        /* Form Elements & Other Definitions Here ... */
        $token = new Zend_Form_Element_Hash("token");
        $token->setTimeout(Application_Model_Cache_Config::getConfig("FORM_CSRF_TOKEN_EXPIRE"));
        
        $work_id = new Zend_Form_Element_Hidden("work_id");
        
        $work_remarks = new Zend_Form_Element_Textarea("work_remarks");
        $work_remarks->setLabel("Remarks")->setRequired(true)->setAttrib('rows', '5');
        
        $work_status = new Zend_Form_Element_Select('work_status');
        $work_status->setRequired(true)->setLabel('Status');
        $work_status->addMultiOption('Pending', 'Pending');
        $work_status->addMultiOption('Start', 'Start');
        $work_status->addMultiOption('Problem', 'Problem');
        $work_status->addMultiOption('Working', 'Working');
        $work_status->addMultiOption('Complete', 'Complete');
        
        $save = new Zend_Form_Element_Submit("save");
        $save->setLabel("Save")->setRequired(true)->setAttrib('class', 'btn btn-primary');
        
        $this->addElements(array($token, $work_id,
        $work_remarks,
        $work_status,
        $save));
    }


}

