<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Activity
 *
 * @author Akhil Kumar
 */
class Application_Model_Activity extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_activity';

    private $_id = null;

    private $_activity_title = null;

    private $_activity_desc = null;

    private $_activity_date = null;

    private $_activity_meta_key = null;

    private $_activity_meta_desc = null;

    private $_activity_url = null;

    private $_activity_status = null;

    private $_activity_updated_by = null;

    private $_activity_updated_date = null;

    private $_activity_created_by = null;

    private $_activity_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get activity_title method is stand for get the value of activity_title.
     *
     * @var varchar activity_title
     */
    public function get_activity_title()
    {
        return $this->_activity_title;
    }

    /**
     * set activity_title method is stand for set the value of activity_title.
     *
     * @var varchar activity_title
     */
    public function set_activity_title($value)
    {
        $this->_activity_title = $value;
    }

    /**
     * get activity_desc method is stand for get the value of activity_desc.
     *
     * @var text activity_desc
     */
    public function get_activity_desc()
    {
        return $this->_activity_desc;
    }

    /**
     * set activity_desc method is stand for set the value of activity_desc.
     *
     * @var text activity_desc
     */
    public function set_activity_desc($value)
    {
        $this->_activity_desc = $value;
    }

    /**
     * get activity_date method is stand for get the value of activity_date.
     *
     * @var date activity_date
     */
    public function get_activity_date()
    {
        return date("d-M-Y", strtotime($this->_activity_date));
    }

    /**
     * set activity_date method is stand for set the value of activity_date.
     *
     * @var date activity_date
     */
    public function set_activity_date($value)
    {
        $this->_activity_date = date("Y-m-d", strtotime($value));
    }

    /**
     * get activity_meta_key method is stand for get the value of activity_meta_key.
     *
     * @var varchar activity_meta_key
     */
    public function get_activity_meta_key()
    {
        return $this->_activity_meta_key;
    }

    /**
     * set activity_meta_key method is stand for set the value of activity_meta_key.
     *
     * @var varchar activity_meta_key
     */
    public function set_activity_meta_key($value)
    {
        $this->_activity_meta_key = $value;
    }

    /**
     * get activity_meta_desc method is stand for get the value of activity_meta_desc.
     *
     * @var varchar activity_meta_desc
     */
    public function get_activity_meta_desc()
    {
        return $this->_activity_meta_desc;
    }

    /**
     * set activity_meta_desc method is stand for set the value of activity_meta_desc.
     *
     * @var varchar activity_meta_desc
     */
    public function set_activity_meta_desc($value)
    {
        $this->_activity_meta_desc = $value;
    }

    /**
     * get activity_url method is stand for get the value of activity_url.
     *
     * @var varchar activity_url
     */
    public function get_activity_url()
    {
        return $this->_activity_url;
    }

    /**
     * set activity_url method is stand for set the value of activity_url.
     *
     * @var varchar activity_url
     */
    public function set_activity_url($value)
    {
        $this->_activity_url = $value;
    }

    /**
     * get activity_status method is stand for get the value of activity_status.
     *
     * @var varchar activity_status
     */
    public function get_activity_status()
    {
        return $this->_activity_status;
    }

    /**
     * set activity_status method is stand for set the value of activity_status.
     *
     * @var varchar activity_status
     */
    public function set_activity_status($value)
    {
        $this->_activity_status = $value;
    }

    /**
     * get activity_updated_by method is stand for get the value of
     * activity_updated_by.
     *
     * @var int activity_updated_by
     */
    public function get_activity_updated_by()
    {
        return (int) $this->_activity_updated_by;
    }

    /**
     * set activity_updated_by method is stand for set the value of
     * activity_updated_by.
     *
     * @var int activity_updated_by
     */
    public function set_activity_updated_by($value)
    {
        $this->_activity_updated_by = (int) $value;
    }

    /**
     * get activity_updated_date method is stand for get the value of
     * activity_updated_date.
     *
     * @var timestamp activity_updated_date
     */
    public function get_activity_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_activity_updated_date));
    }

    /**
     * set activity_updated_date method is stand for set the value of
     * activity_updated_date.
     *
     * @var timestamp activity_updated_date
     */
    public function set_activity_updated_date($value)
    {
        $this->_activity_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get activity_created_by method is stand for get the value of
     * activity_created_by.
     *
     * @var int activity_created_by
     */
    public function get_activity_created_by()
    {
        return (int) $this->_activity_created_by;
    }

    /**
     * set activity_created_by method is stand for set the value of
     * activity_created_by.
     *
     * @var int activity_created_by
     */
    public function set_activity_created_by($value)
    {
        $this->_activity_created_by = (int) $value;
    }

    /**
     * get activity_created_date method is stand for get the value of
     * activity_created_date.
     *
     * @var timestamp activity_created_date
     */
    public function get_activity_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_activity_created_date));
    }

    /**
     * set activity_created_date method is stand for set the value of
     * activity_created_date.
     *
     * @var timestamp activity_created_date
     */
    public function set_activity_created_date($value)
    {
        $this->_activity_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_activity by set id thru constructor.
     *
     * @var int id
     * @var varchar activity_title
     * @var text activity_desc
     * @var date activity_date
     * @var varchar activity_meta_key
     * @var varchar activity_meta_desc
     * @var varchar activity_url
     * @var varchar activity_status
     * @var int activity_updated_by
     * @var timestamp activity_updated_date
     * @var int activity_created_by
     * @var timestamp activity_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_activity_title($row->activity_title);
          $this->set_activity_desc($row->activity_desc);
          $this->set_activity_date($row->activity_date);
          $this->set_activity_meta_key($row->activity_meta_key);
          $this->set_activity_meta_desc($row->activity_meta_desc);
          $this->set_activity_url($row->activity_url);
          $this->set_activity_status($row->activity_status);
          $this->set_activity_updated_by($row->activity_updated_by);
          $this->set_activity_updated_date($row->activity_updated_date);
          $this->set_activity_created_by($row->activity_created_by);
          $this->set_activity_created_date($row->activity_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar activity_title
     * @var text activity_desc
     * @var date activity_date
     * @var varchar activity_meta_key
     * @var varchar activity_meta_desc
     * @var varchar activity_url
     * @var varchar activity_status
     * @var int activity_updated_by
     * @var int activity_created_by
     */
    public function save()
    {
        $data = array(
          "activity_title" => $this->get_activity_title(),
          "activity_desc" => $this->get_activity_desc(),
          "activity_date" => date("Y-m-d", strtotime($this->get_activity_date())),
          "activity_meta_key" => $this->get_activity_meta_key(),
          "activity_meta_desc" => $this->get_activity_meta_desc(),
          "activity_url" => $this->get_activity_url(),
          "activity_status" => $this->get_activity_status(),
          "activity_updated_by" => $this->get_activity_updated_by(),
          "activity_created_by" => $this->get_activity_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_activity by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_activity_title_by_id method is stand for get the value ofactivity_title By
     * id.
     *
     * @var varchar activity_title
     */
    public function get_activity_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_activity_title();
    }

    /**
     * get_activity_desc_by_id method is stand for get the value ofactivity_desc By id.
     *
     * @var text activity_desc
     */
    public function get_activity_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_activity_desc();
    }

    /**
     * get_activity_date_by_id method is stand for get the value ofactivity_date By id.
     *
     * @var date activity_date
     */
    public function get_activity_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y", strtotime($this->get_activity_date()));
    }

    /**
     * get_activity_meta_key_by_id method is stand for get the value
     * ofactivity_meta_key By id.
     *
     * @var varchar activity_meta_key
     */
    public function get_activity_meta_key_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_activity_meta_key();
    }

    /**
     * get_activity_meta_desc_by_id method is stand for get the value
     * ofactivity_meta_desc By id.
     *
     * @var varchar activity_meta_desc
     */
    public function get_activity_meta_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_activity_meta_desc();
    }

    /**
     * get_activity_url_by_id method is stand for get the value ofactivity_url By id.
     *
     * @var varchar activity_url
     */
    public function get_activity_url_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_activity_url();
    }

    /**
     * get_activity_status_by_id method is stand for get the value ofactivity_status By
     * id.
     *
     * @var varchar activity_status
     */
    public function get_activity_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_activity_status();
    }

    /**
     * get_activity_updated_by_by_id method is stand for get the value
     * ofactivity_updated_by By id.
     *
     * @var int activity_updated_by
     */
    public function get_activity_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_activity_updated_by();
    }

    /**
     * get_activity_updated_date_by_id method is stand for get the value
     * ofactivity_updated_date By id.
     *
     * @var timestamp activity_updated_date
     */
    public function get_activity_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_activity_updated_date()));
    }

    /**
     * get_activity_created_by_by_id method is stand for get the value
     * ofactivity_created_by By id.
     *
     * @var int activity_created_by
     */
    public function get_activity_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_activity_created_by();
    }

    /**
     * get_activity_created_date_by_id method is stand for get the value
     * ofactivity_created_date By id.
     *
     * @var timestamp activity_created_date
     */
    public function get_activity_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_activity_created_date()));
    }


}
