<?php

class Application_Model_ActivityLogic extends Application_Model_Activity
{
    public function fetchDataTableSelect()
    {
        $columns = array('activity_date', 'activity_title', 'activity_url', 'activity_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_ActivityLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('activity_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Activity:Edit")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"activity", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Activity:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"activity", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array(date('d-M-Y', strtotime($row->activity_date)), $row->activity_title, $row->activity_url, ($row->activity_status == 'A') ? 'Active' : 'Block', $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
    public function getActiveActivities($isSelect = false) {
        $where = $this->select()->where('activity_status = ?', 'A')->order('activity_date desc');
        return ($isSelect) ? $where : $this->fetchAll($where);
    }
    
    public function selectActiveActivities() {
        $where = $this->select()->where('activity_status = ?', 'A')->order('activity_title');
        return $where;
    }
    
    public function countActivityUrl($url) {
        $where = $this->select()->where('activity_status = ?', 'A')->where('activity_url = ?', $url);
        return count($this->fetchAll($where));
    }
    
    public function generateActivityUrl($url) {
        $url = strtolower(preg_replace('/[^a-zA-Z0-9]/', '-', $url));
        $existRecord = $this->countActivityUrl($url);
        if($existRecord > 0) {
            return $url.'-'.$existRecord;
        }else {
            return $url;
        }
    }
    
    public function getActivityByUrl($url) {
        $where = $this->select()->where('activity_url = ?', $url)->where('activity_status = ?', 'A');
        $row = $this->fetchRow($where);
        $this->set_id($row['id']);
        $this->fetch();
    }
}

