<?php

class Application_Model_Album extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_album';

    private $_id = null;

    private $_album_title = null;

    private $_album_desc = null;

    private $_album_type = null;

    private $_album_cover = null;

    private $_album_url = null;

    private $_album_status = null;

    private $_album_updated_by = null;

    private $_album_updated_date = null;

    private $_album_created_by = null;

    private $_album_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get album_title method is stand for get the value of album_title.
     *
     * @var varchar album_title
     */
    public function get_album_title()
    {
        return $this->_album_title;
    }

    /**
     * set album_title method is stand for set the value of album_title.
     *
     * @var varchar album_title
     */
    public function set_album_title($value)
    {
        $this->_album_title = $value;
    }

    /**
     * get album_desc method is stand for get the value of album_desc.
     *
     * @var varchar album_desc
     */
    public function get_album_desc()
    {
        return $this->_album_desc;
    }

    /**
     * set album_desc method is stand for set the value of album_desc.
     *
     * @var varchar album_desc
     */
    public function set_album_desc($value)
    {
        $this->_album_desc = $value;
    }

    /**
     * get album_type method is stand for get the value of album_type.
     *
     * @var varchar album_type
     */
    public function get_album_type()
    {
        return $this->_album_type;
    }

    /**
     * set album_type method is stand for set the value of album_type.
     *
     * @var varchar album_type
     */
    public function set_album_type($value)
    {
        $this->_album_type = $value;
    }

    /**
     * get album_cover method is stand for get the value of album_cover.
     *
     * @var varchar album_cover
     */
    public function get_album_cover()
    {
        return $this->_album_cover;
    }

    /**
     * set album_cover method is stand for set the value of album_cover.
     *
     * @var varchar album_cover
     */
    public function set_album_cover($value)
    {
        $this->_album_cover = $value;
    }

    /**
     * get album_url method is stand for get the value of album_url.
     *
     * @var varchar album_url
     */
    public function get_album_url()
    {
        return $this->_album_url;
    }

    /**
     * set album_url method is stand for set the value of album_url.
     *
     * @var varchar album_url
     */
    public function set_album_url($value)
    {
        $this->_album_url = $value;
    }

    /**
     * get album_status method is stand for get the value of album_status.
     *
     * @var varchar album_status
     */
    public function get_album_status()
    {
        return $this->_album_status;
    }

    /**
     * set album_status method is stand for set the value of album_status.
     *
     * @var varchar album_status
     */
    public function set_album_status($value)
    {
        $this->_album_status = $value;
    }

    /**
     * get album_updated_by method is stand for get the value of album_updated_by.
     *
     * @var int album_updated_by
     */
    public function get_album_updated_by()
    {
        return (int) $this->_album_updated_by;
    }

    /**
     * set album_updated_by method is stand for set the value of album_updated_by.
     *
     * @var int album_updated_by
     */
    public function set_album_updated_by($value)
    {
        $this->_album_updated_by = (int) $value;
    }

    /**
     * get album_updated_date method is stand for get the value of album_updated_date.
     *
     * @var timestamp album_updated_date
     */
    public function get_album_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_album_updated_date));
    }

    /**
     * set album_updated_date method is stand for set the value of album_updated_date.
     *
     * @var timestamp album_updated_date
     */
    public function set_album_updated_date($value)
    {
        $this->_album_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get album_created_by method is stand for get the value of album_created_by.
     *
     * @var int album_created_by
     */
    public function get_album_created_by()
    {
        return (int) $this->_album_created_by;
    }

    /**
     * set album_created_by method is stand for set the value of album_created_by.
     *
     * @var int album_created_by
     */
    public function set_album_created_by($value)
    {
        $this->_album_created_by = (int) $value;
    }

    /**
     * get album_created_date method is stand for get the value of album_created_date.
     *
     * @var timestamp album_created_date
     */
    public function get_album_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_album_created_date));
    }

    /**
     * set album_created_date method is stand for set the value of album_created_date.
     *
     * @var timestamp album_created_date
     */
    public function set_album_created_date($value)
    {
        $this->_album_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_album by set id thru constructor.
     *
     * @var int id
     * @var varchar album_title
     * @var varchar album_desc
     * @var varchar album_type
     * @var varchar album_cover
     * @var varchar album_url
     * @var int album_site
     * @var varchar album_status
     * @var int album_updated_by
     * @var timestamp album_updated_date
     * @var int album_created_by
     * @var timestamp album_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_album_title($row->album_title);
          $this->set_album_desc($row->album_desc);
          $this->set_album_type($row->album_type);
          $this->set_album_cover($row->album_cover);
          $this->set_album_url($row->album_url);
          $this->set_album_status($row->album_status);
          $this->set_album_updated_by($row->album_updated_by);
          $this->set_album_updated_date($row->album_updated_date);
          $this->set_album_created_by($row->album_created_by);
          $this->set_album_created_date($row->album_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar album_title
     * @var varchar album_desc
     * @var varchar album_type
     * @var varchar album_cover
     * @var varchar album_url
     * @var int album_site
     * @var varchar album_status
     * @var int album_updated_by
     * @var int album_created_by
     */
    public function save()
    {
        $data = array(
          "album_title" => $this->get_album_title(),
          "album_desc" => $this->get_album_desc(),
          "album_type" => $this->get_album_type(),
          "album_cover" => $this->get_album_cover(),
          "album_url" => $this->get_album_url(),
          "album_status" => $this->get_album_status(),
          "album_updated_by" => $this->get_album_updated_by(),
          "album_created_by" => $this->get_album_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_album by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_album_title_by_id method is stand for get the value ofalbum_title By id.
     *
     * @var varchar album_title
     */
    public function get_album_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_album_title();
    }

    /**
     * get_album_desc_by_id method is stand for get the value ofalbum_desc By id.
     *
     * @var varchar album_desc
     */
    public function get_album_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_album_desc();
    }

    /**
     * get_album_type_by_id method is stand for get the value ofalbum_type By id.
     *
     * @var varchar album_type
     */
    public function get_album_type_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_album_type();
    }

    /**
     * get_album_cover_by_id method is stand for get the value ofalbum_cover By id.
     *
     * @var varchar album_cover
     */
    public function get_album_cover_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_album_cover();
    }

    /**
     * get_album_url_by_id method is stand for get the value ofalbum_url By id.
     *
     * @var varchar album_url
     */
    public function get_album_url_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_album_url();
    }

    /**
     * get_album_status_by_id method is stand for get the value ofalbum_status By id.
     *
     * @var varchar album_status
     */
    public function get_album_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_album_status();
    }

    /**
     * get_album_updated_by_by_id method is stand for get the value ofalbum_updated_by
     * By id.
     *
     * @var int album_updated_by
     */
    public function get_album_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_album_updated_by();
    }

    /**
     * get_album_updated_date_by_id method is stand for get the value
     * ofalbum_updated_date By id.
     *
     * @var timestamp album_updated_date
     */
    public function get_album_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_album_updated_date()));
    }

    /**
     * get_album_created_by_by_id method is stand for get the value ofalbum_created_by
     * By id.
     *
     * @var int album_created_by
     */
    public function get_album_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_album_created_by();
    }

    /**
     * get_album_created_date_by_id method is stand for get the value
     * ofalbum_created_date By id.
     *
     * @var timestamp album_created_date
     */
    public function get_album_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_album_created_date()));
    }


}
