<?php

class Application_Model_AlbumLogic extends Application_Model_Album
{
    
    public function fetchOrdered($type = null)
    {
        $where = $this->select()->order('album_title');
        if($type != null) {
            $where->where('album_type = ?', $type);
        }
        return $this->fetchAll($where);
    }
    
    public function getActiveAlbums($limit = null)
    {
        $where = $this->select()->order('id desc');
        if($limit != null) {
            $where->limit($limit);
        }
        return $this->fetchAll($where);
    }
    
    public function fetchIdByUrl($url) {
    $where = $this->select()->where('lower(replace(album_url, \' \', \'-\')) = ?', $url)->order('album_title');
            $results = $this->fetchRow($where);
            return $results['id'];
    }
            
    public function fetchDataTableSelect()
    {
        $columns = array('album_title', 'album_desc', 'album_status', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_AlbumLogic(-1)), $columns);
        $where = $obj_data->get_where()->where('album_status != ?', 'D');
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $enc = new Application_Model_Util_Encrypt();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Album:Edit")) {
                $action = '<a href="'.$url->url(array("controller"=>"album", "action"=>"edit", "id"=>$row->id)).'"><input type="button" value="Edit" class="btn btn-info" /></a> ';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Album:Delete")) {
                $action .= '<a href="'.$url->url(array("controller"=>"album", "action"=>"delete", "id"=>$row->id)).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Album:Image:Master")) {
                $action .= '<a href="'.$url->url(array("controller"=>"image", "action"=>"index", "id"=>$row->id)).'"><input type="button" value="Pictures" class="btn btn-green4" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Album:Video:Master")) {
                $action .= '<a href="'.$url->url(array("controller"=>"video", "action"=>"index", "id"=>$row->id)).'"><input type="button" value="Videos" class="btn btn-green4" /></a>';
            }
            
            $status = Application_Model_Cache_Config::getConfig('STATUS_TYPE');
            $results[$i] = array($row->album_title, $row->album_desc, $status[$row->album_status], $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
}

