<?php

class Application_Model_Alert extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_alert';

    private $_id = null;

    private $_alert_title = null;

    private $_alert_description = null;

    private $_alert_user = null;

    private $_alert_is_view = null;

    private $_alert_updated_by = null;

    private $_alert_updated_date = null;

    private $_alert_created_by = null;

    private $_alert_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get alert_title method is stand for get the value of alert_title.
     *
     * @var varchar alert_title
     */
    public function get_alert_title()
    {
        return $this->_alert_title;
    }

    /**
     * set alert_title method is stand for set the value of alert_title.
     *
     * @var varchar alert_title
     */
    public function set_alert_title($value)
    {
        $this->_alert_title = $value;
    }

    /**
     * get alert_description method is stand for get the value of alert_description.
     *
     * @var varchar alert_description
     */
    public function get_alert_description()
    {
        return $this->_alert_description;
    }

    /**
     * set alert_description method is stand for set the value of alert_description.
     *
     * @var varchar alert_description
     */
    public function set_alert_description($value)
    {
        $this->_alert_description = $value;
    }

    /**
     * get alert_user method is stand for get the value of alert_user.
     *
     * @var int alert_user
     */
    public function get_alert_user()
    {
        return (int) $this->_alert_user;
    }

    /**
     * set alert_user method is stand for set the value of alert_user.
     *
     * @var int alert_user
     */
    public function set_alert_user($value)
    {
        $this->_alert_user = (int) $value;
    }

    /**
     * get alert_is_view method is stand for get the value of alert_is_view.
     *
     * @var tinyint alert_is_view
     */
    public function get_alert_is_view()
    {
        return $this->_alert_is_view;
    }

    /**
     * set alert_is_view method is stand for set the value of alert_is_view.
     *
     * @var tinyint alert_is_view
     */
    public function set_alert_is_view($value)
    {
        $this->_alert_is_view = $value;
    }

    /**
     * get alert_updated_by method is stand for get the value of alert_updated_by.
     *
     * @var int alert_updated_by
     */
    public function get_alert_updated_by()
    {
        return (int) $this->_alert_updated_by;
    }

    /**
     * set alert_updated_by method is stand for set the value of alert_updated_by.
     *
     * @var int alert_updated_by
     */
    public function set_alert_updated_by($value)
    {
        $this->_alert_updated_by = (int) $value;
    }

    /**
     * get alert_updated_date method is stand for get the value of alert_updated_date.
     *
     * @var timestamp alert_updated_date
     */
    public function get_alert_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_alert_updated_date));
    }

    /**
     * set alert_updated_date method is stand for set the value of alert_updated_date.
     *
     * @var timestamp alert_updated_date
     */
    public function set_alert_updated_date($value)
    {
        $this->_alert_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get alert_created_by method is stand for get the value of alert_created_by.
     *
     * @var int alert_created_by
     */
    public function get_alert_created_by()
    {
        return (int) $this->_alert_created_by;
    }

    /**
     * set alert_created_by method is stand for set the value of alert_created_by.
     *
     * @var int alert_created_by
     */
    public function set_alert_created_by($value)
    {
        $this->_alert_created_by = (int) $value;
    }

    /**
     * get alert_created_date method is stand for get the value of alert_created_date.
     *
     * @var timestamp alert_created_date
     */
    public function get_alert_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_alert_created_date));
    }

    /**
     * set alert_created_date method is stand for set the value of alert_created_date.
     *
     * @var timestamp alert_created_date
     */
    public function set_alert_created_date($value)
    {
        $this->_alert_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_alert by set id thru constructor.
     *
     * @var int id
     * @var varchar alert_title
     * @var varchar alert_description
     * @var int alert_user
     * @var tinyint alert_is_view
     * @var int alert_updated_by
     * @var timestamp alert_updated_date
     * @var int alert_created_by
     * @var timestamp alert_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_alert_title($row->alert_title);
          $this->set_alert_description($row->alert_description);
          $this->set_alert_user($row->alert_user);
          $this->set_alert_is_view($row->alert_is_view);
          $this->set_alert_updated_by($row->alert_updated_by);
          $this->set_alert_updated_date($row->alert_updated_date);
          $this->set_alert_created_by($row->alert_created_by);
          $this->set_alert_created_date($row->alert_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar alert_title
     * @var varchar alert_description
     * @var int alert_user
     * @var tinyint alert_is_view
     * @var int alert_updated_by
     * @var int alert_created_by
     */
    public function save()
    {
        $data = array(
          "alert_title" => $this->get_alert_title(),
          "alert_description" => $this->get_alert_description(),
          "alert_user" => $this->get_alert_user(),
          "alert_is_view" => $this->get_alert_is_view(),
          "alert_updated_by" => $this->get_alert_updated_by(),
          "alert_created_by" => $this->get_alert_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_alert by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_alert_title_by_id method is stand for get the value ofalert_title By id.
     *
     * @var varchar alert_title
     */
    public function get_alert_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alert_title();
    }

    /**
     * get_alert_description_by_id method is stand for get the value
     * ofalert_description By id.
     *
     * @var varchar alert_description
     */
    public function get_alert_description_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alert_description();
    }

    /**
     * get_alert_user_by_id method is stand for get the value ofalert_user By id.
     *
     * @var int alert_user
     */
    public function get_alert_user_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_alert_user();
    }

    /**
     * get_alert_is_view_by_id method is stand for get the value ofalert_is_view By id.
     *
     * @var tinyint alert_is_view
     */
    public function get_alert_is_view_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alert_is_view();
    }

    /**
     * get_alert_updated_by_by_id method is stand for get the value ofalert_updated_by
     * By id.
     *
     * @var int alert_updated_by
     */
    public function get_alert_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_alert_updated_by();
    }

    /**
     * get_alert_updated_date_by_id method is stand for get the value
     * ofalert_updated_date By id.
     *
     * @var timestamp alert_updated_date
     */
    public function get_alert_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_alert_updated_date()));
    }

    /**
     * get_alert_created_by_by_id method is stand for get the value ofalert_created_by
     * By id.
     *
     * @var int alert_created_by
     */
    public function get_alert_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_alert_created_by();
    }

    /**
     * get_alert_created_date_by_id method is stand for get the value
     * ofalert_created_date By id.
     *
     * @var timestamp alert_created_date
     */
    public function get_alert_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_alert_created_date()));
    }


}
