<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Alumni
 *
 * @author Akhil Kumar
 */
class Application_Model_Alumni extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_alumni';

    private $_id = null;

    private $_alumni_admission_num = null;

    private $_alumni_student_name = null;

    private $_alumni_father_name = null;

    private $_alumni_dob = null;

    private $_alumni_gender = null;

    private $_alumni_address = null;

    private $_alumni_email = null;

    private $_alumni_phone = null;

    private $_alumni_mobile = null;

    private $_alumni_pass_year = null;

    private $_alumni_stream = null;

    private $_alumni_percent = null;

    private $_alumni_degree = null;

    private $_alumni_current_status = null;

    private $_alumni_remarks = null;

    private $_alumni_status = null;

    private $_alumni_updated_by = null;

    private $_alumni_updated_date = null;

    private $_alumni_created_by = null;

    private $_alumni_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get alumni_admission_num method is stand for get the value of
     * alumni_admission_num.
     *
     * @var varchar alumni_admission_num
     */
    public function get_alumni_admission_num()
    {
        return $this->_alumni_admission_num;
    }

    /**
     * set alumni_admission_num method is stand for set the value of
     * alumni_admission_num.
     *
     * @var varchar alumni_admission_num
     */
    public function set_alumni_admission_num($value)
    {
        $this->_alumni_admission_num = $value;
    }

    /**
     * get alumni_student_name method is stand for get the value of
     * alumni_student_name.
     *
     * @var varchar alumni_student_name
     */
    public function get_alumni_student_name()
    {
        return $this->_alumni_student_name;
    }

    /**
     * set alumni_student_name method is stand for set the value of
     * alumni_student_name.
     *
     * @var varchar alumni_student_name
     */
    public function set_alumni_student_name($value)
    {
        $this->_alumni_student_name = $value;
    }

    /**
     * get alumni_father_name method is stand for get the value of alumni_father_name.
     *
     * @var varchar alumni_father_name
     */
    public function get_alumni_father_name()
    {
        return $this->_alumni_father_name;
    }

    /**
     * set alumni_father_name method is stand for set the value of alumni_father_name.
     *
     * @var varchar alumni_father_name
     */
    public function set_alumni_father_name($value)
    {
        $this->_alumni_father_name = $value;
    }

    /**
     * get alumni_dob method is stand for get the value of alumni_dob.
     *
     * @var date alumni_dob
     */
    public function get_alumni_dob()
    {
        return date("d-M-Y", strtotime($this->_alumni_dob));
    }

    /**
     * set alumni_dob method is stand for set the value of alumni_dob.
     *
     * @var date alumni_dob
     */
    public function set_alumni_dob($value)
    {
        $this->_alumni_dob = date("Y-m-d", strtotime($value));
    }

    /**
     * get alumni_gender method is stand for get the value of alumni_gender.
     *
     * @var varchar alumni_gender
     */
    public function get_alumni_gender()
    {
        return $this->_alumni_gender;
    }

    /**
     * set alumni_gender method is stand for set the value of alumni_gender.
     *
     * @var varchar alumni_gender
     */
    public function set_alumni_gender($value)
    {
        $this->_alumni_gender = $value;
    }

    /**
     * get alumni_address method is stand for get the value of alumni_address.
     *
     * @var varchar alumni_address
     */
    public function get_alumni_address()
    {
        return $this->_alumni_address;
    }

    /**
     * set alumni_address method is stand for set the value of alumni_address.
     *
     * @var varchar alumni_address
     */
    public function set_alumni_address($value)
    {
        $this->_alumni_address = $value;
    }

    /**
     * get alumni_email method is stand for get the value of alumni_email.
     *
     * @var varchar alumni_email
     */
    public function get_alumni_email()
    {
        return $this->_alumni_email;
    }

    /**
     * set alumni_email method is stand for set the value of alumni_email.
     *
     * @var varchar alumni_email
     */
    public function set_alumni_email($value)
    {
        $this->_alumni_email = $value;
    }

    /**
     * get alumni_phone method is stand for get the value of alumni_phone.
     *
     * @var varchar alumni_phone
     */
    public function get_alumni_phone()
    {
        return $this->_alumni_phone;
    }

    /**
     * set alumni_phone method is stand for set the value of alumni_phone.
     *
     * @var varchar alumni_phone
     */
    public function set_alumni_phone($value)
    {
        $this->_alumni_phone = $value;
    }

    /**
     * get alumni_mobile method is stand for get the value of alumni_mobile.
     *
     * @var varchar alumni_mobile
     */
    public function get_alumni_mobile()
    {
        return $this->_alumni_mobile;
    }

    /**
     * set alumni_mobile method is stand for set the value of alumni_mobile.
     *
     * @var varchar alumni_mobile
     */
    public function set_alumni_mobile($value)
    {
        $this->_alumni_mobile = $value;
    }

    /**
     * get alumni_pass_year method is stand for get the value of alumni_pass_year.
     *
     * @var year(4) alumni_pass_year
     */
    public function get_alumni_pass_year()
    {
        return $this->_alumni_pass_year;
    }

    /**
     * set alumni_pass_year method is stand for set the value of alumni_pass_year.
     *
     * @var year(4) alumni_pass_year
     */
    public function set_alumni_pass_year($value)
    {
        $this->_alumni_pass_year = $value;
    }

    /**
     * get alumni_stream method is stand for get the value of alumni_stream.
     *
     * @var varchar alumni_stream
     */
    public function get_alumni_stream()
    {
        return $this->_alumni_stream;
    }

    /**
     * set alumni_stream method is stand for set the value of alumni_stream.
     *
     * @var varchar alumni_stream
     */
    public function set_alumni_stream($value)
    {
        $this->_alumni_stream = $value;
    }

    /**
     * get alumni_percent method is stand for get the value of alumni_percent.
     *
     * @var varchar alumni_percent
     */
    public function get_alumni_percent()
    {
        return $this->_alumni_percent;
    }

    /**
     * set alumni_percent method is stand for set the value of alumni_percent.
     *
     * @var varchar alumni_percent
     */
    public function set_alumni_percent($value)
    {
        $this->_alumni_percent = $value;
    }

    /**
     * get alumni_degree method is stand for get the value of alumni_degree.
     *
     * @var varchar alumni_degree
     */
    public function get_alumni_degree()
    {
        return $this->_alumni_degree;
    }

    /**
     * set alumni_degree method is stand for set the value of alumni_degree.
     *
     * @var varchar alumni_degree
     */
    public function set_alumni_degree($value)
    {
        $this->_alumni_degree = $value;
    }

    /**
     * get alumni_current_status method is stand for get the value of
     * alumni_current_status.
     *
     * @var varchar alumni_current_status
     */
    public function get_alumni_current_status()
    {
        return $this->_alumni_current_status;
    }

    /**
     * set alumni_current_status method is stand for set the value of
     * alumni_current_status.
     *
     * @var varchar alumni_current_status
     */
    public function set_alumni_current_status($value)
    {
        $this->_alumni_current_status = $value;
    }

    /**
     * get alumni_remarks method is stand for get the value of alumni_remarks.
     *
     * @var varchar alumni_remarks
     */
    public function get_alumni_remarks()
    {
        return $this->_alumni_remarks;
    }

    /**
     * set alumni_remarks method is stand for set the value of alumni_remarks.
     *
     * @var varchar alumni_remarks
     */
    public function set_alumni_remarks($value)
    {
        $this->_alumni_remarks = $value;
    }

    /**
     * get alumni_status method is stand for get the value of alumni_status.
     *
     * @var varchar alumni_status
     */
    public function get_alumni_status()
    {
        return $this->_alumni_status;
    }

    /**
     * set alumni_status method is stand for set the value of alumni_status.
     *
     * @var varchar alumni_status
     */
    public function set_alumni_status($value)
    {
        $this->_alumni_status = $value;
    }

    /**
     * get alumni_updated_by method is stand for get the value of alumni_updated_by.
     *
     * @var int alumni_updated_by
     */
    public function get_alumni_updated_by()
    {
        return (int) $this->_alumni_updated_by;
    }

    /**
     * set alumni_updated_by method is stand for set the value of alumni_updated_by.
     *
     * @var int alumni_updated_by
     */
    public function set_alumni_updated_by($value)
    {
        $this->_alumni_updated_by = (int) $value;
    }

    /**
     * get alumni_updated_date method is stand for get the value of
     * alumni_updated_date.
     *
     * @var timestamp alumni_updated_date
     */
    public function get_alumni_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_alumni_updated_date));
    }

    /**
     * set alumni_updated_date method is stand for set the value of
     * alumni_updated_date.
     *
     * @var timestamp alumni_updated_date
     */
    public function set_alumni_updated_date($value)
    {
        $this->_alumni_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get alumni_created_by method is stand for get the value of alumni_created_by.
     *
     * @var int alumni_created_by
     */
    public function get_alumni_created_by()
    {
        return (int) $this->_alumni_created_by;
    }

    /**
     * set alumni_created_by method is stand for set the value of alumni_created_by.
     *
     * @var int alumni_created_by
     */
    public function set_alumni_created_by($value)
    {
        $this->_alumni_created_by = (int) $value;
    }

    /**
     * get alumni_created_date method is stand for get the value of
     * alumni_created_date.
     *
     * @var timestamp alumni_created_date
     */
    public function get_alumni_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_alumni_created_date));
    }

    /**
     * set alumni_created_date method is stand for set the value of
     * alumni_created_date.
     *
     * @var timestamp alumni_created_date
     */
    public function set_alumni_created_date($value)
    {
        $this->_alumni_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_alumni by set id thru constructor.
     *
     * @var int id
     * @var varchar alumni_admission_num
     * @var varchar alumni_student_name
     * @var varchar alumni_father_name
     * @var date alumni_dob
     * @var varchar alumni_gender
     * @var varchar alumni_address
     * @var varchar alumni_email
     * @var varchar alumni_phone
     * @var varchar alumni_mobile
     * @var year(4) alumni_pass_year
     * @var varchar alumni_stream
     * @var varchar alumni_percent
     * @var varchar alumni_degree
     * @var varchar alumni_current_status
     * @var varchar alumni_remarks
     * @var varchar alumni_status
     * @var int alumni_updated_by
     * @var timestamp alumni_updated_date
     * @var int alumni_created_by
     * @var timestamp alumni_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_alumni_admission_num($row->alumni_admission_num);
          $this->set_alumni_student_name($row->alumni_student_name);
          $this->set_alumni_father_name($row->alumni_father_name);
          $this->set_alumni_dob($row->alumni_dob);
          $this->set_alumni_gender($row->alumni_gender);
          $this->set_alumni_address($row->alumni_address);
          $this->set_alumni_email($row->alumni_email);
          $this->set_alumni_phone($row->alumni_phone);
          $this->set_alumni_mobile($row->alumni_mobile);
          $this->set_alumni_pass_year($row->alumni_pass_year);
          $this->set_alumni_stream($row->alumni_stream);
          $this->set_alumni_percent($row->alumni_percent);
          $this->set_alumni_degree($row->alumni_degree);
          $this->set_alumni_current_status($row->alumni_current_status);
          $this->set_alumni_remarks($row->alumni_remarks);
          $this->set_alumni_status($row->alumni_status);
          $this->set_alumni_updated_by($row->alumni_updated_by);
          $this->set_alumni_updated_date($row->alumni_updated_date);
          $this->set_alumni_created_by($row->alumni_created_by);
          $this->set_alumni_created_date($row->alumni_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar alumni_admission_num
     * @var varchar alumni_student_name
     * @var varchar alumni_father_name
     * @var date alumni_dob
     * @var varchar alumni_gender
     * @var varchar alumni_address
     * @var varchar alumni_email
     * @var varchar alumni_phone
     * @var varchar alumni_mobile
     * @var year(4) alumni_pass_year
     * @var varchar alumni_stream
     * @var varchar alumni_percent
     * @var varchar alumni_degree
     * @var varchar alumni_current_status
     * @var varchar alumni_remarks
     * @var varchar alumni_status
     * @var int alumni_updated_by
     * @var int alumni_created_by
     */
    public function save()
    {
        $data = array(
          "alumni_admission_num" => $this->get_alumni_admission_num(),
          "alumni_student_name" => $this->get_alumni_student_name(),
          "alumni_father_name" => $this->get_alumni_father_name(),
          "alumni_dob" => date("Y-m-d", strtotime($this->get_alumni_dob())),
          "alumni_gender" => $this->get_alumni_gender(),
          "alumni_address" => $this->get_alumni_address(),
          "alumni_email" => $this->get_alumni_email(),
          "alumni_phone" => $this->get_alumni_phone(),
          "alumni_mobile" => $this->get_alumni_mobile(),
          "alumni_pass_year" => $this->get_alumni_pass_year(),
          "alumni_stream" => $this->get_alumni_stream(),
          "alumni_percent" => $this->get_alumni_percent(),
          "alumni_degree" => $this->get_alumni_degree(),
          "alumni_current_status" => $this->get_alumni_current_status(),
          "alumni_remarks" => $this->get_alumni_remarks(),
          "alumni_status" => $this->get_alumni_status(),
          "alumni_updated_by" => $this->get_alumni_updated_by(),
          "alumni_created_by" => $this->get_alumni_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_alumni by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_alumni_admission_num_by_id method is stand for get the value
     * ofalumni_admission_num By id.
     *
     * @var varchar alumni_admission_num
     */
    public function get_alumni_admission_num_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_admission_num();
    }

    /**
     * get_alumni_student_name_by_id method is stand for get the value
     * ofalumni_student_name By id.
     *
     * @var varchar alumni_student_name
     */
    public function get_alumni_student_name_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_student_name();
    }

    /**
     * get_alumni_father_name_by_id method is stand for get the value
     * ofalumni_father_name By id.
     *
     * @var varchar alumni_father_name
     */
    public function get_alumni_father_name_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_father_name();
    }

    /**
     * get_alumni_dob_by_id method is stand for get the value ofalumni_dob By id.
     *
     * @var date alumni_dob
     */
    public function get_alumni_dob_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y", strtotime($this->get_alumni_dob()));
    }

    /**
     * get_alumni_gender_by_id method is stand for get the value ofalumni_gender By id.
     *
     * @var varchar alumni_gender
     */
    public function get_alumni_gender_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_gender();
    }

    /**
     * get_alumni_address_by_id method is stand for get the value ofalumni_address By
     * id.
     *
     * @var varchar alumni_address
     */
    public function get_alumni_address_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_address();
    }

    /**
     * get_alumni_email_by_id method is stand for get the value ofalumni_email By id.
     *
     * @var varchar alumni_email
     */
    public function get_alumni_email_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_email();
    }

    /**
     * get_alumni_phone_by_id method is stand for get the value ofalumni_phone By id.
     *
     * @var varchar alumni_phone
     */
    public function get_alumni_phone_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_phone();
    }

    /**
     * get_alumni_mobile_by_id method is stand for get the value ofalumni_mobile By id.
     *
     * @var varchar alumni_mobile
     */
    public function get_alumni_mobile_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_mobile();
    }

    /**
     * get_alumni_pass_year_by_id method is stand for get the value ofalumni_pass_year
     * By id.
     *
     * @var year(4) alumni_pass_year
     */
    public function get_alumni_pass_year_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_pass_year();
    }

    /**
     * get_alumni_stream_by_id method is stand for get the value ofalumni_stream By id.
     *
     * @var varchar alumni_stream
     */
    public function get_alumni_stream_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_stream();
    }

    /**
     * get_alumni_percent_by_id method is stand for get the value ofalumni_percent By
     * id.
     *
     * @var varchar alumni_percent
     */
    public function get_alumni_percent_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_percent();
    }

    /**
     * get_alumni_degree_by_id method is stand for get the value ofalumni_degree By id.
     *
     * @var varchar alumni_degree
     */
    public function get_alumni_degree_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_degree();
    }

    /**
     * get_alumni_current_status_by_id method is stand for get the value
     * ofalumni_current_status By id.
     *
     * @var varchar alumni_current_status
     */
    public function get_alumni_current_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_current_status();
    }

    /**
     * get_alumni_remarks_by_id method is stand for get the value ofalumni_remarks By
     * id.
     *
     * @var varchar alumni_remarks
     */
    public function get_alumni_remarks_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_remarks();
    }

    /**
     * get_alumni_status_by_id method is stand for get the value ofalumni_status By id.
     *
     * @var varchar alumni_status
     */
    public function get_alumni_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_alumni_status();
    }

    /**
     * get_alumni_updated_by_by_id method is stand for get the value
     * ofalumni_updated_by By id.
     *
     * @var int alumni_updated_by
     */
    public function get_alumni_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_alumni_updated_by();
    }

    /**
     * get_alumni_updated_date_by_id method is stand for get the value
     * ofalumni_updated_date By id.
     *
     * @var timestamp alumni_updated_date
     */
    public function get_alumni_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_alumni_updated_date()));
    }

    /**
     * get_alumni_created_by_by_id method is stand for get the value
     * ofalumni_created_by By id.
     *
     * @var int alumni_created_by
     */
    public function get_alumni_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_alumni_created_by();
    }

    /**
     * get_alumni_created_date_by_id method is stand for get the value
     * ofalumni_created_date By id.
     *
     * @var timestamp alumni_created_date
     */
    public function get_alumni_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_alumni_created_date()));
    }


}
