<?php

class Application_Model_AlumniLogic extends Application_Model_Alumni
{
    public function fetchDataTableSelect()
    {
        $columns = array('alumni_admission_num', 'alumni_student_name', 'alumni_father_name', 'alumni_dob', 'alumni_pass_year', 'action');
        $obj_data = new Application_Model_Util_Datatable((new Application_Model_AlumniLogic(-1)), $columns);
        $where = $obj_data->get_where();
        $where->where('alumni_status != ?', 'D');
        $obj_data->set_where($where);
        $rows = $obj_data->fetch();
        $results = array();
        $i = 0;
        $url = new Zend_View_Helper_Url();
        $enc = new Application_Model_Util_Encrypt();
        foreach($rows as $row)
        {
            $action = '';
            if(Application_Model_RolePermissionLogic::isPermitted("Alumni:View")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"alumni", "action"=>"view", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="View" class="btn btn-info" /></a>';
            }
            if(Application_Model_RolePermissionLogic::isPermitted("Alumni:Delete")) {
                $action .= '<a href="'.$url->url(array("module"=>"dynasty", "controller"=>"alumni", "action"=>"delete", "id"=>$enc->hideContent($row->id))).'"><input type="button" value="Delete" class="btn btn-danger" /></a>';
            }
            $results[$i] = array($row->alumni_admission_num, $row->alumni_student_name, $row->alumni_father_name, date('d-M-Y', strtotime($row->alumni_dob)), $row->alumni_pass_year, $action);
            $i += 1;
        }
        return $obj_data->configureOutput($results);
    }
    
}

