<?php

class Application_Model_Blog extends Zend_Db_Table_Abstract
{

    protected $_name = 'asit_blog';

    private $_id = null;

    private $_blog_title = null;

    private $_blog_image = null;

    private $_blog_category = null;

    private $_blog_short_desc = null;

    private $_blog_desc = null;

    private $_blog_url = null;

    private $_blog_meta_key = null;

    private $_blog_meta_desc = null;

    private $_blog_status = null;

    private $_blog_updated_by = null;

    private $_blog_updated_date = null;

    private $_blog_created_by = null;

    private $_blog_created_date = null;

    /**
     * Constructor initialize primary key field value to set the set_id method. If
     * value = -1 then default object loaded.
     *
     * @var int id
     */
    public function __construct($id)
    {
        parent::__construct();
        $id = (int) $id;
        $this->set_id($id);
        if($id!=-1)
        {
          $this->fetch();
        }
    }

    /**
     * get id method is stand for get the value of id.
     *
     * @var int id
     */
    public function get_id()
    {
        return (int) $this->_id;
    }

    /**
     * set id method is stand for set the value of id.
     *
     * @var int id
     */
    public function set_id($value)
    {
        $this->_id = (int) $value;
    }

    /**
     * get blog_title method is stand for get the value of blog_title.
     *
     * @var varchar blog_title
     */
    public function get_blog_title()
    {
        return $this->_blog_title;
    }

    /**
     * set blog_title method is stand for set the value of blog_title.
     *
     * @var varchar blog_title
     */
    public function set_blog_title($value)
    {
        $this->_blog_title = $value;
    }

    /**
     * get blog_image method is stand for get the value of blog_image.
     *
     * @var varchar blog_image
     */
    public function get_blog_image()
    {
        return $this->_blog_image;
    }

    /**
     * set blog_image method is stand for set the value of blog_image.
     *
     * @var varchar blog_image
     */
    public function set_blog_image($value)
    {
        $this->_blog_image = $value;
    }

    /**
     * get blog_category method is stand for get the value of blog_category.
     *
     * @var int blog_category
     */
    public function get_blog_category()
    {
        return (int) $this->_blog_category;
    }

    /**
     * set blog_category method is stand for set the value of blog_category.
     *
     * @var int blog_category
     */
    public function set_blog_category($value)
    {
        $this->_blog_category = (int) $value;
    }

    /**
     * get blog_short_desc method is stand for get the value of blog_short_desc.
     *
     * @var varchar blog_short_desc
     */
    public function get_blog_short_desc()
    {
        return $this->_blog_short_desc;
    }

    /**
     * set blog_short_desc method is stand for set the value of blog_short_desc.
     *
     * @var varchar blog_short_desc
     */
    public function set_blog_short_desc($value)
    {
        $this->_blog_short_desc = $value;
    }

    /**
     * get blog_desc method is stand for get the value of blog_desc.
     *
     * @var text blog_desc
     */
    public function get_blog_desc()
    {
        return $this->_blog_desc;
    }

    /**
     * set blog_desc method is stand for set the value of blog_desc.
     *
     * @var text blog_desc
     */
    public function set_blog_desc($value)
    {
        $this->_blog_desc = $value;
    }

    /**
     * get blog_url method is stand for get the value of blog_url.
     *
     * @var varchar blog_url
     */
    public function get_blog_url()
    {
        return $this->_blog_url;
    }

    /**
     * set blog_url method is stand for set the value of blog_url.
     *
     * @var varchar blog_url
     */
    public function set_blog_url($value)
    {
        $this->_blog_url = $value;
    }

    /**
     * get blog_meta_key method is stand for get the value of blog_meta_key.
     *
     * @var varchar blog_meta_key
     */
    public function get_blog_meta_key()
    {
        return $this->_blog_meta_key;
    }

    /**
     * set blog_meta_key method is stand for set the value of blog_meta_key.
     *
     * @var varchar blog_meta_key
     */
    public function set_blog_meta_key($value)
    {
        $this->_blog_meta_key = $value;
    }

    /**
     * get blog_meta_desc method is stand for get the value of blog_meta_desc.
     *
     * @var varchar blog_meta_desc
     */
    public function get_blog_meta_desc()
    {
        return $this->_blog_meta_desc;
    }

    /**
     * set blog_meta_desc method is stand for set the value of blog_meta_desc.
     *
     * @var varchar blog_meta_desc
     */
    public function set_blog_meta_desc($value)
    {
        $this->_blog_meta_desc = $value;
    }

    /**
     * get blog_status method is stand for get the value of blog_status.
     *
     * @var varchar blog_status
     */
    public function get_blog_status()
    {
        return $this->_blog_status;
    }

    /**
     * set blog_status method is stand for set the value of blog_status.
     *
     * @var varchar blog_status
     */
    public function set_blog_status($value)
    {
        $this->_blog_status = $value;
    }

    /**
     * get blog_updated_by method is stand for get the value of blog_updated_by.
     *
     * @var int blog_updated_by
     */
    public function get_blog_updated_by()
    {
        return (int) $this->_blog_updated_by;
    }

    /**
     * set blog_updated_by method is stand for set the value of blog_updated_by.
     *
     * @var int blog_updated_by
     */
    public function set_blog_updated_by($value)
    {
        $this->_blog_updated_by = (int) $value;
    }

    /**
     * get blog_updated_date method is stand for get the value of blog_updated_date.
     *
     * @var timestamp blog_updated_date
     */
    public function get_blog_updated_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_blog_updated_date));
    }

    /**
     * set blog_updated_date method is stand for set the value of blog_updated_date.
     *
     * @var timestamp blog_updated_date
     */
    public function set_blog_updated_date($value)
    {
        $this->_blog_updated_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * get blog_created_by method is stand for get the value of blog_created_by.
     *
     * @var int blog_created_by
     */
    public function get_blog_created_by()
    {
        return (int) $this->_blog_created_by;
    }

    /**
     * set blog_created_by method is stand for set the value of blog_created_by.
     *
     * @var int blog_created_by
     */
    public function set_blog_created_by($value)
    {
        $this->_blog_created_by = (int) $value;
    }

    /**
     * get blog_created_date method is stand for get the value of blog_created_date.
     *
     * @var timestamp blog_created_date
     */
    public function get_blog_created_date()
    {
        return date("d-M-Y (H:i:s)", strtotime($this->_blog_created_date));
    }

    /**
     * set blog_created_date method is stand for set the value of blog_created_date.
     *
     * @var timestamp blog_created_date
     */
    public function set_blog_created_date($value)
    {
        $this->_blog_created_date = date("Y-m-d H:i:s", strtotime($value));
    }

    /**
     * fetch data from asit_blog by set id thru constructor.
     *
     * @var int id
     * @var varchar blog_title
     * @var varchar blog_image
     * @var int blog_category
     * @var varchar blog_short_desc
     * @var text blog_desc
     * @var varchar blog_url
     * @var varchar blog_meta_key
     * @var varchar blog_meta_desc
     * @var varchar blog_status
     * @var int blog_updated_by
     * @var timestamp blog_updated_date
     * @var int blog_created_by
     * @var timestamp blog_created_date
     */
    public function fetch()
    {
        $select=$this->select()->where("id = ?",$this->get_id());
        $row=$this->fetchRow($select);
        if($row!=null){
          $this->set_id($row->id);
          $this->set_blog_title($row->blog_title);
          $this->set_blog_image($row->blog_image);
          $this->set_blog_category($row->blog_category);
          $this->set_blog_short_desc($row->blog_short_desc);
          $this->set_blog_desc($row->blog_desc);
          $this->set_blog_url($row->blog_url);
          $this->set_blog_meta_key($row->blog_meta_key);
          $this->set_blog_meta_desc($row->blog_meta_desc);
          $this->set_blog_status($row->blog_status);
          $this->set_blog_updated_by($row->blog_updated_by);
          $this->set_blog_updated_date($row->blog_updated_date);
          $this->set_blog_created_by($row->blog_created_by);
          $this->set_blog_created_date($row->blog_created_date);
        }
    }

    /**
     * save method is stand for saving the data, if id = -1 then data insert as a new
     * record and if id is set via constructor then data should update
     *
     * @var varchar blog_title
     * @var varchar blog_image
     * @var int blog_category
     * @var varchar blog_short_desc
     * @var text blog_desc
     * @var varchar blog_url
     * @var varchar blog_meta_key
     * @var varchar blog_meta_desc
     * @var varchar blog_status
     * @var int blog_updated_by
     * @var int blog_created_by
     */
    public function save()
    {
        $data = array(
          "blog_title" => $this->get_blog_title(),
          "blog_image" => $this->get_blog_image(),
          "blog_category" => $this->get_blog_category(),
          "blog_short_desc" => $this->get_blog_short_desc(),
          "blog_desc" => $this->get_blog_desc(),
          "blog_url" => $this->get_blog_url(),
          "blog_meta_key" => $this->get_blog_meta_key(),
          "blog_meta_desc" => $this->get_blog_meta_desc(),
          "blog_status" => $this->get_blog_status(),
          "blog_updated_by" => $this->get_blog_updated_by(),
          "blog_created_by" => $this->get_blog_created_by());
        if($this->get_id()==-1)
        {
          return $this->insert($data);
        }
        else
        {
          $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
          $this->update($data, $where);
        }
    }

    /**
     * remove method delete the record from asit_blog by id.
     *
     * @var int id
     */
    public function remove()
    {
        $where = $this->getAdapter()->quoteInto("id = ?", $this->get_id());
        $this->delete($where);
    }

    /**
     * fetch_list_select stand for selecting all records.
     */
    public function fetch_list_select()
    {
        $select = $this->select();
        return $select;
    }

    /**
     * get_blog_title_by_id method is stand for get the value ofblog_title By id.
     *
     * @var varchar blog_title
     */
    public function get_blog_title_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_blog_title();
    }

    /**
     * get_blog_image_by_id method is stand for get the value ofblog_image By id.
     *
     * @var varchar blog_image
     */
    public function get_blog_image_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_blog_image();
    }

    /**
     * get_blog_category_by_id method is stand for get the value ofblog_category By id.
     *
     * @var int blog_category
     */
    public function get_blog_category_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_blog_category();
    }

    /**
     * get_blog_short_desc_by_id method is stand for get the value ofblog_short_desc By
     * id.
     *
     * @var varchar blog_short_desc
     */
    public function get_blog_short_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_blog_short_desc();
    }

    /**
     * get_blog_desc_by_id method is stand for get the value ofblog_desc By id.
     *
     * @var text blog_desc
     */
    public function get_blog_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_blog_desc();
    }

    /**
     * get_blog_url_by_id method is stand for get the value ofblog_url By id.
     *
     * @var varchar blog_url
     */
    public function get_blog_url_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_blog_url();
    }

    /**
     * get_blog_meta_key_by_id method is stand for get the value ofblog_meta_key By id.
     *
     * @var varchar blog_meta_key
     */
    public function get_blog_meta_key_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_blog_meta_key();
    }

    /**
     * get_blog_meta_desc_by_id method is stand for get the value ofblog_meta_desc By
     * id.
     *
     * @var varchar blog_meta_desc
     */
    public function get_blog_meta_desc_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_blog_meta_desc();
    }

    /**
     * get_blog_status_by_id method is stand for get the value ofblog_status By id.
     *
     * @var varchar blog_status
     */
    public function get_blog_status_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return $this->get_blog_status();
    }

    /**
     * get_blog_updated_by_by_id method is stand for get the value ofblog_updated_by By
     * id.
     *
     * @var int blog_updated_by
     */
    public function get_blog_updated_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_blog_updated_by();
    }

    /**
     * get_blog_updated_date_by_id method is stand for get the value
     * ofblog_updated_date By id.
     *
     * @var timestamp blog_updated_date
     */
    public function get_blog_updated_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_blog_updated_date()));
    }

    /**
     * get_blog_created_by_by_id method is stand for get the value ofblog_created_by By
     * id.
     *
     * @var int blog_created_by
     */
    public function get_blog_created_by_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return (int) $this->get_blog_created_by();
    }

    /**
     * get_blog_created_date_by_id method is stand for get the value
     * ofblog_created_date By id.
     *
     * @var timestamp blog_created_date
     */
    public function get_blog_created_date_by_id($id)
    {
        $this->set_id($id);
        $this->fetch();
        return date("d-M-Y (H:i:s)", strtotime($this->get_blog_created_date()));
    }


}
